% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcds.R
\name{getCDsFor1Molecule}
\alias{getCDsFor1Molecule}
\title{Get Chemical Descriptors for a single molecule}
\usage{
getCDsFor1Molecule(smi = "O=C(O)CCCCCCCCCO", cache = TRUE, verbose = 1)
}
\arguments{
\item{smi}{SMILES string of the molecule.}

\item{cache}{If TRUE, the results are cached in RAM and on disk at directory \verb{~/.cache/FastRet/getCDsFor1Molecule/} to speed up subsequent calls.}

\item{verbose}{Verbosity. 0: no output, 1: show progress.}
}
\value{
A dataframe of dimension 1 x 241. The rowname is the input SMILES string. The colnames are the chemical descriptor features specified by \link{CDFeatures}.
}
\description{
Helper function for \code{\link[=getCDs]{getCDs()}}. Calculates chemical descriptors for a single molecule, specified as \href{https://en.wikipedia.org/wiki/Simplified_molecular-input_line-entry_system}{SMILES} string. This function should NOT be used directly. It is only exported so \code{\link[=getCDs]{getCDs()}} can easily spawn background worker processes that are able to call this function.
}
\details{
Chemical descriptors in \code{\link[=getCDs]{getCDs()}} are calculated individually for each molecule. This is due to the inconsistent ordering of output dataframes when a list of \code{IAtomContainer} objects is provided to \code{rcdk::eval.desc}. Although the input SMILES are set as rownames, they don't match the original input SMILES due to an unclear transformation, making mapping non-trivial. Calculating descriptors molecule by molecule also enables parallelization in \code{\link[=getCDs]{getCDs()}}.
}
\examples{
cds <- getCDsFor1Molecule("O=C(O)CCCCCCCCCO", cache = TRUE, verbose = 0)
}
\seealso{
\code{\link[=getCDs]{getCDs()}}, \link{CDFeatures}
}
\keyword{internal}
