% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{BERT_info}
\alias{BERT_info}
\title{Get basic information of BERT models.}
\usage{
BERT_info(models = NULL)
}
\arguments{
\item{models}{Model names at
\href{https://huggingface.co/models?pipeline_tag=fill-mask&library=transformers}{HuggingFace}.}
}
\value{
A data.table:
\itemize{
\item model name
\item model type
\item number of parameters
\item vocabulary size (of word/token embeddings)
\item embedding dimensions (of word/token embeddings)
\item hidden layers
\item [MASK] token
}
}
\description{
Get basic information of BERT models.
}
\examples{
\dontrun{
models = c("bert-base-uncased", "bert-base-cased")
BERT_info(models)

BERT_info()  # information of all downloaded models
}

}
\seealso{
\code{\link{BERT_download}}

\code{\link{BERT_vocab}}
}
