% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{plot.femlm.cluster}
\alias{plot.femlm.cluster}
\title{Plots the most notable fixed-effects}
\usage{
\method{plot}{femlm.cluster}(x, n = 5, ...)
}
\arguments{
\item{x}{An object obtained from the function \code{\link{getFE}}.}

\item{n}{The number of fixed-effects to be drawn. Defaults to 5.}

\item{...}{Not currently used.}
}
\description{
This method plots the most notable fixed effects of a cluster obtained from function \code{\link[FENmlm]{getFE}}.
}
\details{
Note that the fixed-effect coefficients might NOT be interpretable. This function is useful only for fully regular panels.

If the data are not regular in the cluster coefficients, this means that several \sQuote{reference points} are set to obtain the fixed-effects, thereby impeding their interpretation. In this case a warning is raised.
}
\examples{

data(trade)

# We estimate the effect of distance on trade
# => we account for 3 cluster effects
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# obtaining the cluster coefficients
fe_trade = getFE(est_pois)

# plotting them
plot(fe_trade)

# plotting only the Products fixed-effects & showing more of them
plot(fe_trade$Product, n=8)


}
\seealso{
To plot all the fixed-effects of all clusters, use function \code{\link[FENmlm]{plot.femlm.allClusters}}.
 See also the main estimation function \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
