% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.evaluate.core.R
\name{dist.evaluate.core}
\alias{dist.evaluate.core}
\title{Distance Measures}
\usage{
dist.evaluate.core(data, names, quantitative, qualitative, selected, d = NULL)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{d}{A distance matrix of class "\code{dist}" with individual names in
the \code{names} column in {data} as labels. If \code{NULL} (default),
then a distance matrix is computed using Gower's metric.
\insertCite{gowerGeneralCoefficientSimilarity1971}{EvaluateCore}.}
}
\value{
A data frame with the average values of
\mjteqn{E\textrm{-}EN}{E\text{-}EN}{E-EN},
\mjteqn{A\textrm{-}EN}{E\text{-}EN}{A-EN} and
\mjteqn{E\textrm{-}E}{E\text{-}EN}{E-E}.
}
\description{
Compute average Entry-to-nearest-entry distance
(\mjteqn{E\textrm{-}EN}{E\text{-}EN}{E-EN}),
Accession-to-nearest-entry distance
(\mjteqn{A\textrm{-}EN}{E\text{-}EN}{A-EN}) and
Entry-to-entry distance (\mjteqn{E\textrm{-}E}{E\text{-}EN}{E-E})
\insertCite{odong_quality_2013}{EvaluateCore}
to evaluate a core set (CS) selected from an entire collection (EC).
\loadmathjax
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

dist.evaluate.core(data = ec, names = "genotypes", quantitative = quant,
                   qualitative = qual, selected = core)

\donttest{
####################################
# Compare with corehunter
####################################

library(corehunter)
# Prepare phenotype dataset
dtype <- c(rep("RD", length(quant)),
           rep("NS", length(qual)))
rownames(ec) <- ec[, "genotypes"]
ecdata <- corehunter::phenotypes(data = ec[, c(quant, qual)],
                                 types = dtype)

# Compute average distances
EN <- evaluateCore(core = rownames(cassava_CC), data = ecdata,
                   objective = objective("EN", "GD"))
AN <- evaluateCore(core = rownames(cassava_CC), data = ecdata,
                   objective = objective("AN", "GD"))
EE <- evaluateCore(core = rownames(cassava_CC), data = ecdata,
                   objective = objective("EE", "GD"))
EN
AN
EE
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[corehunter]{evaluateCore}}
}
