% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/En_Market.Sumarry.R
\name{En_Market.Sumarry}
\alias{En_Market.Sumarry}
\title{Retrieve Summaries of giving Stock Market from Euronext}
\usage{
En_Market.Sumarry(stock_choice)
}
\arguments{
\item{stock_choice}{A character string specifying the market of interest. Available options include "a" or "amsterdam" for Amsterdam, "b" or "brussels" for Brussels, "d" or "dublin" for Dublin, "l" or "lisbon" for Lisbon, "m" or "milan" for Milan, "p" or "paris" for Paris, and "o" or "oslo" for Oslo.}
}
\value{
A list containing summary data for the selected market, including information on stock indices and currency rates. The list includes the following components:
\describe{
\item{Indices_summary}{A data frame summarizing stock market indices for the selected market. It includes columns for the index name, last price, and percentage change. If the summary is not available, this component will be set to NA.}
\item{EU_indices}{A data frame summarizing EURONEXT indices for the selected market. It includes columns for the instrument name, last price, and percentage change. If the summary is not available, this component will be set to NA.}
\item{Currency_rate}{A data frame summarizing currency exchange rates for the selected market. It includes columns for the instrument name, last price, and percentage change. If the summary is not available, this component will be set to NA.}
}
}
\description{
This function retrieves summary data of stock market indices and currency rates from the Euronext website for a selected market. It allows users to obtain real-time information about various financial instruments listed on the Euronext stock exchange, facilitating analysis and decision-making.
}
\examples{
library(httr)
library(rvest)
library(magrittr)

# Note : 'NA' for a giving summary means the summary is not available

# Retrieve summary data for Amsterdam stock
En_Market.Sumarry("a")
# Or
# Retrieve summary data for 'Amsterdam stock indices' only
En_Market.Sumarry("a")$Indices_summary

# Retrieve summary data for 'EURONEXT indices' only
En_Market.Sumarry("a")$EU_indices

# Retrieve summary data for 'Currency rate' only
En_Market.Sumarry("a")$Currency_rate


# Retrieve summary data for 'Brussels stock indices' only
En_Market.Sumarry("b")$Indices_summary

# Retrieve summary data for 'Dublin stock indices' only
En_Market.Sumarry("d")$Indices_summary

# Retrieve summary data for 'Lisbon stock indices' only
En_Market.Sumarry("l")$Indices_summary

# Retrieve summary data for 'Milan stock indices' only
En_Market.Sumarry("m")$Indices_summary

# Retrieve summary data for 'Paris stock indices' only
En_Market.Sumarry("p")$Indices_summary

# Retrieve summary data for 'Oslo stock indices' only
En_Market.Sumarry("o")$Indices_summary

}
\seealso{
\code{\link{EN_Stocks_List}}

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()}

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Infos Retrieval}
