% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Overview_plot.R
\name{EN_Overview_plot}
\alias{EN_Overview_plot}
\title{Euronext OVERVIEW PLOT}
\usage{
EN_Overview_plot(
  ticker,
  from = NULL,
  to = Sys.Date() - 1,
  stock_type = "Eq_Ind",
  escape = FALSE,
  up.col = "darkgreen",
  down.col = "red"
)
}
\arguments{
\item{ticker}{is the Ticker(s) name(s)}

\item{from}{A quoted start date, ie. "2020-01-01" or "2020/01/01". The date
must be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD".}

\item{to}{A quoted end date, ie. "2022-01-31" or "2022/01/31". The date must
be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD"}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes,
'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers,
and 'Etfs' or "E" for ETFs.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is TRUE, it means you're providing
the DNA (ISIN-Market identifier) directly. Giving TRUE to escape is helpful
to avoid time-consuming operations; otherwise, FALSE means you need to provide
the Ticker symbol, name, or ISIN and the type of market to which it belongs.}

\item{up.col}{is the up color}

\item{down.col}{is down color}
}
\value{
An interactive chart
}
\description{
This function will get Ticker(s) data and then plot it.
}
\examples{

\donttest{
library(highcharter)
library(lubridate)
library(rlang)
library(httr2)
library(dplyr)
library(stringr)
library(xts)
library(flextable)
library(grDevices)

#Highchart of 4DDD (area chart for Last price and column chart for volume)
# Default up.col = "darkgreen", down.col = "red"
EN_Overview_plot(c("4DDD"), to = Sys.Date())

# You can change the up and down colors as follow
EN_Overview_plot("AAX", up.col = "blue", down.col = "pink")

# Plot the closing price of a group of 3 tickers
EN_Overview_plot(c("AAX", "QS0011016480", "AEX2S", "ADIDAS", "ADOBE", "ALFEN BEHEER", "1GOOGL"))

# AEX All-Tradable Alternative Weight NR, AEX Equal Weight NR,
# AEX Short GR and AEX X2 Short GR plot overview
EN_Overview_plot(c("NL0010614533", "QS0011211206", "QS0011095914", "QS0011146899"))

# Bond
EN_Overview_plot(c("XS2364001078-XMOT"), stock_type = 'B')

}

}
\seealso{
\code{EN_HistData()} and \code{EN_HistData_bis()}

\code{EN_Ticker_hcData()}

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Plot: 
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_plot}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{Data Retrieval}
\concept{Euronext}
\concept{Plot}
