% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Indices_List.R
\name{EN_Indices_List}
\alias{EN_Indices_List}
\title{Get information about indices listed on Euronext.}
\usage{
EN_Indices_List()
}
\value{
A data frame containing information about the indices, including Name,
ISIN, Symbol, Last price, Percentage change, Date and time, Year-to-date percentage change,
and a composite Ticker_adn.
}
\description{
This function retrieves information about indices available on Euronext.
}
\examples{

\donttest{
library(httr)
library(jsonlite)
library(rvest)
library(stringr)
library(magrittr)
library(rlang)

list_ind <- EN_Indices_List()
head(list_ind[, c(1:5)])
}

}
\seealso{
\code{\link{EN_Stocks_List}} to get the list of tickers quoted on a given Euronext Stock,
\code{\link{EN_Funds_List}} for Funds list, \code{\link{EN_Etfs_List}} for Etfs list.

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{Infos Retrieval}
