% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.gsa.R
\name{eco.gsa}
\alias{eco.gsa}
\title{Global spatial analysis}
\usage{
eco.gsa(Z, Y = NULL, con, method = c("I", "C", "CC", "JC"), ncod = NULL,
  nsim = 99, alternative = c("auto", "two.sided", "greater", "less"),
  adjust = "fdr", row.sd = FALSE, plotit = TRUE)
}
\arguments{
\item{Z}{Vector with a variable, or matrix/data frame with variables in columns.}

\item{Y}{Vector with the second variable for Mantel's Ixy.
If Z has multiple variables, the program will compute the coefficent
for each with Y.}

\item{con}{An object of class eco.weight obtained with the function \code{\link{eco.weight}},
a listw object or a matrix, giving the spatial weights for the analysis. If "con" is a matrix,
an attribute "xy" including the projected coordinates is required.}

\item{method}{Method of analysis: "I" for Moran's I, "C" for Geary's C, "CC" for
the Bivariate Moran's or "JC" for Join-count.}

\item{ncod}{Number of elements coding each category (e.g., if x ncod =1, if xx,
ncod = 2, and so on) for Join-count analysis.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the alternative hypothesis.
Other options are: "two.sided", "greater" and "less".}

\item{adjust}{Correction method of P-values for multiple tests,
passed to \code{\link[stats]{p.adjust}}. Defalut is "fdr".}

\item{row.sd}{Logical. should be row standardized the matrix? Default FALSE
(binary weights).}

\item{plotit}{Should be printed a histogram of the simulation? Defalut TRUE.}
}
\value{
The program returns an object of class "eco.gsa" with the following slots:

@METHOD method used in the analysis

@OBS observed value when a single variable is tested

@EXP expect value when a single variable is tested

@PVAL P-value when a single variable is tested

@ALTER alternative hypotesis when a single variable is tested

@NSIM number of simulations

@MULTI table with observed and expected values, P-values and alternative
hypoteses when multiple variables are tested
}
\description{
This program computes Moran's I, Geary's C,  Bivariate Moran's I or
Join-count statistics with P-values.
}
\examples{
\dontrun{

data(eco.test)

# Moran's I

### one test
con <- eco.weight(eco$XY, method = "circle", d1 = 0, d2 = 2)
global <- eco.gsa(Z = eco$P[, 1], con = con, , method = "I", nsim = 200)
global

require(adegenet)
con2<-chooseCN(eco$XY, type = 1, result.type = "listw", plot.nb = FALSE)
global <- eco.gsa(Z = eco$P[, 1], con = con2, , method = "I", nsim = 200)
global

### multiple tests
con <- eco.weight(eco$XY, method = "circle", d1 = 0, d2 = 2)
global <- eco.gsa(Z = eco$P, con = con, , method = "I", nsim = 200)
global

# Gearys's C

global.C <- eco.gsa(Z = eco$P[, 1], con = con, method = "C", nsim = 200)
global.C

# Bivariate's Moran's Ixy

global.Ixy <- eco.gsa(Z = eco$P[, 1], Y = eco$E[, 1],
con = con, method = "CC", nsim = 200)
global.Ixy

# Join-count

global.JC <- eco.gsa(Z = 2* eco$GENIND$tab[, 1], ncod = 1,
con = con, method = "JC", nsim = 10)
global.JC
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Geary R. 1954. The contiguity ratio and statistical mapping.
The incorporated statistician, 115-146.

Moran P. 1950. Notes on continuous stochastic phenomena. Biometrika, 17-23.

Reich R., R. Czaplewski and W. Bechtold. 1994.
Spatial cross-correlation of undisturbed, natural shortleaf pine stands
in northern Georgia. Environmental and Ecological Statistics, 1: 201-217.

Sokal R. and N. Oden 1978. Spatial autocorrelation in biology:
1. Methodology. Biological journal of the Linnean Society, 10: 199-228.

Sokal R. and N. Oden. 1978. Spatial autocorrelation in biology.
2. Some biological implications and four applications of evolutionary and
ecological interest. Biological Journal of the Linnean Society, 10: 229-49.
}

