% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/genericEGRETplot.R
\name{genericEGRETDotPlot}
\alias{genericEGRETDotPlot}
\title{Generic EGRET plotting function}
\usage{
genericEGRETDotPlot(x, y, xlim, ylim, xTicks, yTicks, printTitle = TRUE,
  xaxs = "i", xlab = "", yaxs = "i", ylab = "", plotTitle = "",
  pch = 20, cex = 0.7, cex.main = 1.3, font.main = 2, cex.lab = 1.2,
  tcl = 0.5, cex.axis = 1, las = 1, xDate = FALSE, tinyPlot = FALSE,
  hLine = FALSE, oneToOneLine = FALSE, rmSciX = FALSE, rmSciY = FALSE,
  customPar = FALSE, col = "black", lwd = 1, showXLabels = TRUE,
  showYLabels = TRUE, showXAxis = TRUE, showYAxis = TRUE,
  removeFirstX = FALSE, removeLastX = FALSE, removeFirstY = FALSE,
  removeLastY = FALSE, ...)
}
\arguments{
\item{x}{vector specifying the x data (required)}

\item{y}{vector specifying the y data (required)}

\item{xlim}{vector specifying the x plotting range (required)}

\item{ylim}{vector specifying the y plotting range (required)}

\item{xTicks}{vector specifying x axis tick placement (required)}

\item{yTicks}{vector specifying y axis tick placement (required)}

\item{printTitle}{logical defaults to TRUE, plotting parameter to control whether to have title}

\item{xaxs}{character defaults to "i", defines the style of x-axis interval calculation.  Possible values are i, r, e, s, d.}

\item{xlab}{character defaults to "", defines the x label}

\item{yaxs}{character defaults to "i", defines the style of y-axis interval calculation.  Possible values are i, r, e, s, d.}

\item{ylab}{character defaults to "", defines the y label}

\item{plotTitle}{character defaults to "", defines the plot title}

\item{pch}{number defaults to 20, specifies plot symbol}

\item{cex}{number defaults to 0.7, specifies plotting text magnification}

\item{cex.main}{number defaults to 1.3, specifies title text magnification}

\item{font.main}{number defaults to 2, specifies which font to use for text}

\item{cex.lab}{number defaults to 1.2 specifies label text magnification}

\item{tcl}{number defaults to 0.5, specifies length of tick marks as fraction of height of a line of text.}

\item{cex.axis}{number defaults to 1, specifies axis text magnification}

\item{las}{number represents style of axis labels}

\item{xDate}{logical defaults to FALSE, changes x label to "year-month" format if set to TRUE and total years less than 4.}

\item{tinyPlot}{logical defaults to FALSE, if TRUE, changes defaults to be appropriate for multi-plot}

\item{hLine}{logical defaults to FALSE, inserts horizontal line at zero}

\item{oneToOneLine}{logical defaults to FALSE, inserts 1:1 line}

\item{rmSciX}{logical defaults to FALSE, changes x label from scientific to fixed}

\item{rmSciY}{logical defaults to FALSE, changes y label from scientific to fixed}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}

\item{showXLabels}{logical defaults to TRUE. If FALSE, the x axis label is not plotted}

\item{showYLabels}{logical defaults to TRUE. If FALSE, the y axis label is not plotted}

\item{showXAxis}{logical defaults to TRUE. If FALSE, the x axis is not plotted}

\item{showYAxis}{logical defaults to TRUE. If FALSE, the y axis is not plotted}

\item{removeFirstX}{logical defaults to FALSE. If TRUE, removes the first x axis label. This can be handy for plotting mutliple plots.}

\item{removeLastX}{logical defaults to FALSE. If TRUE, removes the last x axis label. This can be handy for plotting mutliple plots.}

\item{removeFirstY}{logical defaults to FALSE. If TRUE, removes the first y axis label. This can be handy for plotting mutliple plots.}

\item{removeLastY}{logical defaults to FALSE. If TRUE, removes the last y axis label. This can be handy for plotting mutliple plots.}

\item{\dots}{additional graphical parameters can be adjusted}
}
\description{
Basic plotting framework for EGRET dot plots. Graphical parameters default to values that work well with most plots, but all can be re-assigned.
See ?par for complete definitions of most optional input variables.
}
\examples{
eList <- Choptank_eList
Daily <- getDaily(eList)
x <- Daily$Date
y <- Daily$Q
xlim <- c(min(x),max(x))
ylim <- c(min(y),1.05*max(y))
xlab <- "Date"
ylab <- "Flow"
xTicks <- pretty(xlim)
yTicks <- pretty(ylim)
genericEGRETDotPlot(x=x, y=y,
                    xlim=xlim, ylim=ylim,
                    xlab=xlab, ylab=ylab,
                    xTicks=xTicks, yTicks=yTicks,
                    plotTitle="Test"
)
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}

