% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fixSampleFrame.R
\name{fixSampleFrame}
\alias{fixSampleFrame}
\title{Update Sample dataframe}
\usage{
fixSampleFrame(eList)
}
\arguments{
\item{eList}{named list with at least the Sample dataframes}
}
\value{
localSample data frame
}
\description{
Used for updating the Sample dataframe if ConcLow or ConcHigh is manually adjusted.
Adjusts ConcAve and Uncen columns.
}
\examples{
eList <- Choptank_eList
Sample <- eList$Sample
Sample[1,c("ConcLow","ConcHigh")] <- c(NA, 0.01) # Adjusted to left-censored
Sample[2,c("ConcLow","ConcHigh")] <- c(1.1, 1.3) # Adjusted to interval-censored
Sample[3,c("ConcLow","ConcHigh")] <- c(1.3, 1.3) # Simple adjustment
eList$Sample <- Sample
eList <- fixSampleFrame(eList)
eList$Sample[1:3,]
}
\keyword{WRTDS}
\keyword{flow}

