% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readWQPSample}
\alias{readWQPSample}
\title{Import Sample Data for WRTDS}
\usage{
readWQPSample(siteNumber, characteristicName, startDate, endDate,
  interactive = TRUE)
}
\arguments{
\item{siteNumber}{character site number.  If USGS, it should be in the form :'USGS-XXXXXXXXX...'}

\item{characteristicName}{character}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
Sample dataframe
}
\description{
Imports data from the Water Quality Portal, so it could be STORET, NWIS, or . This function gets the data from: \url{http://www.waterqualitydata.us}
For raw data, use readWQPdata.  This function will retrieve the raw data, and compress it (summing constituents). See
chapter 7 of the EGRET user guide for more details, then converts it to the Sample dataframe structure.
}
\examples{
# These examples require an internet connection to run
\dontrun{
Sample_01075 <- readWQPSample('USGS-01594440','Chloride', '', '')
Sample_All <- readWQPSample('WIDNR_WQX-10032762','Specific conductance', '', '')
}
}
\seealso{
\code{\link[dataRetrieval]{readWQPdata}}, \code{\link[dataRetrieval]{whatWQPsites}},
\code{\link[dataRetrieval]{readWQPqw}}, \code{\link[dataRetrieval]{readNWISqw}},
\code{\link{compressData}}, \code{\link{populateSampleColumns}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

