% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{fetch_401k}
\alias{fetch_401k}
\title{Data set on financial wealth and 401(k) plan participation.}
\usage{
fetch_401k(return_type = "DoubleMLData", polynomial_features = FALSE)
}
\arguments{
\item{return_type}{(\code{character(1)}) \cr
If \code{"DoubleMLData"}, returns a \code{DoubleMLData} object. If \code{"data.frame"} returns a \code{data.frame()}. If \code{"data.table"} returns a \code{data.table()}. Default is \code{"DoubleMLData"}.}

\item{polynomial_features}{(\code{logical(1)}) \cr
If \code{TRUE} polynomial freatures are added (see replication file of Chernozhukov et al. (2018)).}
}
\value{
A data object according to the choice of \code{return_type}.
}
\description{
Data set on financial wealth and 401(k) plan participation. An internet connection is required to sucessfully download the data set.
}
\details{
Variable description, based on the supplementary material of Chernozhukov et al. (2020):
\itemize{
\item net_tfa: net total financial assets
\item e401: = 1 if employer offers 401(k)
\item age
\item inc: income
\item fsize: family size
\item educ: years of education
\item db: = 1 if indivuduals has defined benefit pension
\item marr: = 1 if married
\item twoearn: = 1 if two-earner household
\item pira: = 1 if individual participates in IRA plan
\item hown: = 1 if home owner
}

The supplementary data of the study by Chernozhukov et al. (2018) is available at \url{https://academic.oup.com/ectj/article/21/1/C1/5056401#supplementary-data}.
}
\references{
Abadie, A. (2003), Semiparametric instrumental variable estimation of treatment response models. Journal of Econometrics, 113(2): 231-263.

Chernozhukov, V., Chetverikov, D., Demirer, M., Duflo, E., Hansen, C., Newey, W. and Robins, J. (2018), Double/debiased machine learning for treatment and structural parameters. The Econometrics Journal, 21: C1-C68. doi:\href{https://doi.org/10.1111/ectj.12097}{10.1111/ectj.12097}.
}
