/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.rosuda.deducer.widgets.DeducerWidget;

public class SliderWidget
extends JPanel
implements DeducerWidget {
    private JSlider slider;
    private String title;
    private String[] endPoints;
    private Integer initialModel;
    private Integer lastModel;

    public SliderWidget(String string, String[] stringArray) {
        this.title = string;
        this.endPoints = stringArray;
        this.initGUI();
    }

    public SliderWidget(String[] stringArray) {
        this(null, stringArray);
    }

    public SliderWidget(String string) {
        this(string, null);
    }

    private void initGUI() {
        try {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayout(borderLayout);
            this.setPreferredSize(new Dimension(185, 40));
            if (this.title != null) {
                this.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            this.slider = new JSlider(0, 0, 100, 1);
            if (this.endPoints != null && this.endPoints.length == 2) {
                this.slider.setMajorTickSpacing(100);
                Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                hashtable.put(new Integer(0), new JLabel(this.endPoints[0]));
                hashtable.put(new Integer(100), new JLabel(this.endPoints[1]));
                this.slider.setLabelTable(hashtable);
                this.slider.setPaintTicks(true);
                this.slider.setPaintLabels(true);
            }
            this.add((Component)this.slider, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public Object getModel() {
        return new Integer(this.slider.getValue());
    }

    public String getRModel() {
        return this.getModel().toString();
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setDefaultModel(Object object) {
        this.initialModel = (Integer)object;
        if (this.lastModel == null) {
            this.lastModel = (Integer)object;
        }
    }

    public void setLastModel(Object object) {
        this.lastModel = (Integer)object;
    }

    public void setModel(Object object) {
        if (object == null) {
            this.slider.setValue(0);
        } else {
            this.slider.setValue((Integer)object);
        }
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

