/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import javax.swing.DefaultComboBoxModel;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamTwoValueWidget;
import org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ParamVector
extends Param {
    protected String[] value = new String[0];
    protected String[] defaultValue = new String[0];
    protected boolean numeric = true;

    public ParamVector() {
        this.name = "";
        this.title = "";
        this.view = "org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget";
    }

    public ParamVector(String string) {
        this.name = string;
        this.title = string;
        this.view = "org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget";
    }

    public ParamVector(String string, String[] stringArray) {
        this.name = string;
        this.title = string;
        this.value = stringArray;
        this.defaultValue = stringArray;
        this.view = "org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget";
    }

    public ParamVector(String string, String string2, String string3, String[] stringArray, String[] stringArray2, boolean bl) {
        this.name = string;
        this.title = string2;
        this.view = string3;
        this.value = stringArray;
        this.defaultValue = stringArray2;
        this.view = "org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget";
        this.setNumeric(bl);
    }

    public ParamWidget getView() {
        if (this.getViewType().equals("org.rosuda.deducer.widgets.param.ParamTwoValueWidget")) {
            return new ParamTwoValueWidget(this);
        }
        if (this.getViewType().equals("org.rosuda.deducer.widgets.param.ParamVectorBuilderWidget")) {
            return new ParamVectorBuilderWidget(this);
        }
        System.out.println("invalid view");
        new Exception().printStackTrace();
        return null;
    }

    public Object clone() {
        int n;
        String[] stringArray;
        String[] stringArray2;
        ParamVector paramVector = new ParamVector();
        paramVector.setName(this.getName());
        paramVector.setTitle(this.getTitle());
        if (this.getLowerBound() != null) {
            paramVector.setLowerBound(new Double(this.getLowerBound()));
        }
        if (this.getUpperBound() != null) {
            paramVector.setUpperBound(new Double(this.getUpperBound()));
        }
        paramVector.setViewType(this.getViewType());
        if (this.getValue() != null) {
            stringArray2 = (String[])this.getValue();
            stringArray = new String[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray[n] = stringArray2[n];
            }
            paramVector.setValue(stringArray);
        }
        if (this.getDefaultValue() != null) {
            stringArray2 = (String[])this.getDefaultValue();
            stringArray = new String[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray[n] = stringArray2[n];
            }
            paramVector.setDefaultValue(stringArray);
        }
        paramVector.setNumeric(this.isNumeric());
        paramVector.required = this.required;
        return paramVector;
    }

    public String[] getParamCalls() {
        String[] stringArray;
        if (this.getValue() != null && !this.getValue().equals(this.getDefaultValue())) {
            String string = "";
            String[] stringArray2 = (String[])this.getValue();
            String[] stringArray3 = (String[])this.getDefaultValue();
            boolean bl = true;
            if (stringArray2 == null) {
                bl = true;
            } else if (stringArray3 == null) {
                bl = false;
            } else if (stringArray2.length != stringArray3.length) {
                bl = false;
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].equals(stringArray3[i])) continue;
                    bl = false;
                }
            }
            string = !bl && stringArray2 != null ? Deducer.makeRCollection(new DefaultComboBoxModel<String>(stringArray2), "c", false) : "";
            stringArray = string.length() > 0 ? new String[]{(this.name != null ? this.name + " = " : "") + string} : new String[]{};
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void setDefaultValue(Object object) {
        if (object instanceof String[] || object == null) {
            this.defaultValue = (String[])object;
        } else {
            System.out.println("ParamVector: invalid setDefaultValue");
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Object object) {
        if (object instanceof String[] || object == null) {
            this.value = (String[])object;
        } else {
            System.out.println("ParamVector: invalid setValue");
            Exception exception = new Exception();
            exception.printStackTrace();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public Element toXML() {
        int n;
        Element element = super.toXML();
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("value");
        if (this.value != null) {
            for (n = 0; n < this.value.length; ++n) {
                element2.setAttribute("element_" + n, this.value[n]);
            }
        }
        element.appendChild(element2);
        element2 = document.createElement("defaultValue");
        if (this.defaultValue != null) {
            for (n = 0; n < this.defaultValue.length; ++n) {
                element2.setAttribute("element_" + n, this.defaultValue[n]);
            }
        }
        element.appendChild(element2);
        element.setAttribute("numeric", this.numeric ? "true" : "false");
        element.setAttribute("className", "org.rosuda.deducer.widgets.param.ParamVector");
        return element;
    }

    public void setFromXML(Element element) {
        int n;
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.widgets.param.ParamVector")) {
            System.out.println("Error ParamVector: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        super.setFromXML(element);
        this.value = new String[0];
        this.defaultValue = new String[0];
        Node node = element.getElementsByTagName("value").item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            this.value = new String[namedNodeMap.getLength()];
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                this.value[n] = namedNodeMap.item(n).getNodeValue();
            }
        }
        if ((namedNodeMap = (node = element.getElementsByTagName("defaultValue").item(0)).getAttributes()).getLength() > 0) {
            this.defaultValue = new String[namedNodeMap.getLength()];
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                this.defaultValue[n] = namedNodeMap.item(n).getNodeValue();
            }
        }
    }

    public boolean hasValidEntry() {
        return this.value != null && this.value.length > 0 || this.defaultValue != null && this.defaultValue.length > 0;
    }
}

