% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAVF_exp_score.R
\name{SAVF_exp_score}
\alias{SAVF_exp_score}
\title{Single Attribute Value Function (SAVF) Exponential Score}
\usage{
SAVF_exp_score(x, x_low, x_mid, x_high, increasing = TRUE)
}
\arguments{
\item{x}{Attribute raw value}

\item{x_low}{Lowest value}

\item{x_mid}{Midpoint value}

\item{x_high}{Highest value}

\item{increasing}{TRUE=increasing, FALSE=decreasing, Default: TRUE}
}
\value{
Exponential SAVF Score
}
\description{
: Calculates the Single Attribute Values Function (SAVF) score for an exponentially increasing or decreasing function. 
It calls the SAVF_calc_rho function, so knowing rho beforehand is not necessary.
}
\details{
For Z=((x_mid - x_low) / (x_high - x_low)),
Z can not be in (0.51,0.49)
}
\examples{
SAVF_exp_score(70, 0, 90, 150, FALSE)

}
