% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSLiteServer.R
\name{newDSLiteServer}
\alias{newDSLiteServer}
\title{Create a new DSLite server}
\usage{
newDSLiteServer(
  tables = list(),
  config = DSLite::defaultDSConfiguration(),
  strict = TRUE,
  home = file.path(tempdir(), ".dslite")
)
}
\arguments{
\item{tables}{A named list of data.frames representing the harmonized tables.}

\item{config}{The DataSHIELD configuration. Default is to discover it from the DataSHIELD server-side R packages.
See \link{defaultDSConfiguration} function for including or excluding packages when discovering the DataSHIELD configuration
from the DataSHIELD server-side packages (meta-data from the DESCRIPTION files).}

\item{strict}{Logical to specify whether the DataSHIELD configuration must be strictly applied. Default is TRUE.}

\item{home}{Folder location where are located the session work directory and where to read and dump workspace images.
Default is in a hidden folder of the R session's temporary directory.}
}
\description{
Shortcut function to create a new \code{DSLiteServer} instance.
}
\seealso{
Other server-side items: 
\code{\link{DSLiteServer}}
}
\concept{server-side items}
