% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbGetStatement}
\alias{dbGetStatement}
\title{Get the statement associated with a result set}
\usage{
dbGetStatement(res, ...)
}
\arguments{
\item{res}{An object inheriting from \code{\linkS4class{DBIResult}}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
a character vector
}
\description{
Returns the statement that was passed to \code{\link{dbSendQuery}}.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
rs <- dbSendQuery(con, "SELECT * FROM mtcars")
dbGetStatement(rs)

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{SQL}}, \code{\link{dbBind}},
  \code{\link{dbClearResult}}, \code{\link{dbColumnInfo}},
  \code{\link{dbFetch}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}}
}

