% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_time_dep.R
\name{DAISIE_sim_time_dep}
\alias{DAISIE_sim_time_dep}
\title{Simulate (non-)oceanic islands with given parameters under a
  time-dependent regime}
\usage{
DAISIE_sim_time_dep(
  time,
  M,
  pars,
  replicates,
  area_pars,
  hyper_pars,
  divdepmodel = "CS",
  nonoceanic_pars = c(0, 0),
  num_guilds = NULL,
  sample_freq = 25,
  plot_sims = TRUE,
  island_ontogeny = "const",
  sea_level = "const",
  extcutoff = 1000,
  cond = 0,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{time}{Numeric defining the length of the simulation in time units.
For example, if an island is known to be 4 million years old, setting
time = 4 will simulate the entire life span of the island; setting time = 2
will stop the simulation at the mid-life of the island.}

\item{M}{Numeric defining the size of mainland pool, i.e. the number of
species that can potentially colonize the island.}

\item{pars}{A numeric vector containing the model parameters:
\itemize{
  \item{\code{pars[1]}: lambda^c (cladogenesis rate)}
  \item{\code{pars[2]}: mu (extinction rate)}
  \item{\code{pars[3]}: K (carrying capacity), set K=Inf for diversity
  independence.}
  \item{\code{pars[4]}: gamma (immigration rate)}
  \item{\code{pars[5]}: lambda^a (anagenesis rate)}
  \item{\code{pars[6]}: lambda^c (cladogenesis rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[7]}: mu (extinction rate) for either type 2 species or rate
  set 2 in rate shift model}
  \item{\code{pars[8]}: K (carrying capacity) for either type 2 species or rate
  set 2 in rate shift model, set K=Inf for diversity independence.}
  \item{\code{pars[9]}: gamma (immigration rate) for either type 2 species
  or rate set 2 in rate shift model}
  \item{\code{pars[10]}: lambda^a (anagenesis rate) for either type 2
  species or rate set 2 in rate shift model}
}
Elements 6:10 are required only when type 2 species are included
or in the rate shift model. For \code{\link{DAISIE_sim_relaxed_rate}()}
\code{pars[6]} is the standard deviation of the gamma distribution for the
relaxed parameter and the parameter chosen by the \code{relaxed_par}
argument is the mean of the gamma distribution for the relaxed parameter.}

\item{replicates}{Integer specifying number of island replicates to be
simulated.}

\item{area_pars}{A named list containing area and sea level parameters as
created by \code{\link{create_area_pars}()}:
\itemize{
  \item{[1]: maximum area}
  \item{[2]: current area}
  \item{[3]: value from 0 to 1 indicating where in the island's history the
  peak area is achieved}
  \item{[4]: total island age}
  \item{[5]: amplitude of area fluctuation from sea level}
  \item{[6]: frequency of sine wave of area change from sea level}
  \item{[7]: angle of the slope of the island}
}}

\item{hyper_pars}{A named list of numeric hyperparameters for the rate
calculations as returned by \code{\link{create_hyper_pars}()}:
\itemize{
  \item{[1]: is d the scaling parameter for exponent for calculating
  cladogenesis rate}
  \item{[2]: is x the exponent for calculating extinction rate}
}}

\item{divdepmodel}{Option divdepmodel = 'CS' runs a model with clade-specific
carrying capacity, where diversity-dependence operates only within single
clades, i.e. only among species originating from the same mainland
colonist. Option divdepmodel = 'IW' runs a model with island-wide
carrying capacity, where diversity-dependence operates within and among
clades. Option divdepmodel = 'GW' runs a model with diversity-dependence
operates within a guild.}

\item{nonoceanic_pars}{A vector of length two with:
\itemize{
  \item{[1]: the probability of sampling a species from the mainland}
  \item{[2]: the probability of the species sampled from the mainland
  being nonendemic}
}}

\item{num_guilds}{The number of guilds on the mainland. The number of
mainland species is divided by the number of guilds when
\code{divdepmodel = "GW"}}

\item{sample_freq}{Numeric specifing the number of units times should be
divided by for plotting purposes. Larger values will lead to plots with
higher resolution, but will also run slower.}

\item{plot_sims}{\code{Default = TRUE} plots species-through-time (STT)
plots. It detects how many types of species are present. If only one type
of species is present, STT is plotted for all species. If two types are
present, three plots are produced: STT for all, STT for type 1 and STT for
type 2.}

\item{island_ontogeny}{In \code{\link{DAISIE_sim_time_dep}()},
\code{\link{DAISIE_ML_CS}} and plotting a string describing the type of
island ontogeny. Can be \code{"const"}, \code{"beta"} for a beta function
describing area through time. \cr In all other functions a
numeric describing the type of island ontogeny. Can be \code{0} for
constant, \code{1} for a beta function describing area through time. In ML
functions \code{island_ontogeny = NA} assumes constant ontogeny. Time
dependent estimation is not yet available as development is still ongoing.
Will return an error if called in that case.}

\item{sea_level}{In \code{\link{DAISIE_sim_time_dep}()} and plotting a
string describing the type of sea level. Can be \code{"const"} or
\code{"sine"} for a sine function describing area through time.
\cr In all other functions a numeric describing the type of sea level. Can
be \code{0} for constant, \code{1} for a sine function describing area
through time.}

\item{extcutoff}{A numeric with the cutoff for the the maximum extinction
rate preventing it from being too large and slowing down simulation.}

\item{cond}{cond = 0 : conditioning on island age \cr cond = 1 :
conditioning on island age and non-extinction of the island biota \cr.
cond > 1 : conditioning on island age and having at least cond colonizations
on the island. This last option is not yet available for the IW model \cr}

\item{verbose}{A numeric vector of length 1, which in simulations and
`DAISIEdataprep()` can be `1` or `0`, where `1` gives intermediate output
should be printed.
For ML functions a numeric determining if intermediate output should be
printed. The default: `0` does not print, `1` prints the initial
likelihood and the settings that were selected (which parameters are
to be optimised, fixed or shifted), `2` prints the same as `1 and also the
intermediate output of the parameters and loglikelihood, while `3` the
same as `2` and prints intermediate progress during likelihood computation.}

\item{...}{Any arguments to pass on to plotting functions.}
}
\value{
A list. The highest level of the least corresponds to each individual
replciate. The first element of each replicate is composed of island
information containing:
\itemize{
  \item{\code{$island_age}: A numeric with the island age.}
  \item{\code{$not_present}: A numeric with the number of mainland lineages
  that are not present on the island.}
  \item{\code{$stt_all}: STT table for all species on the island
    (nI - number of non-endemic species; nA - number of anagenetic species,
    nC - number of cladogenetic species, present - number of independent
    colonisations present)}
  \item{\code{$brts_table}: Only for simulations under \code{"IW"}. Table
containing information on order of events in the data, for use in maximum
likelihood optimization.).}
}
The subsequent elements of the list pertaining to each replcate contain
information on a single colonist lineage on the island and have 4 components:
\itemize{
  \item{\code{$branching_times}: island age and stem age of the
    population/species in the case of Non-endemic, Non-endemic_MaxAge and
    Endemic anagenetic species. For cladogenetic species these should
    be island age and branching times of the radiation including the
    stem age of the radiation.}
  \item{\code{$stac}: An integer ranging from 1 to 4
  indicating the status of the colonist:}
  \enumerate{
    \item Non_endemic_MaxAge
    \item Endemic
    \item Endemic&Non_Endemic
    \item Non_endemic_MaxAge
}
\item{\code{$missing_species}: number of island species that were
not sampled for particular clade (only applicable for endemic clades)}
\item{\code{$type_1or2}: whether the colonist belongs to type 1 or type 2}
}
}
\description{
This function simulates islands with given cladogenesis,
extinction, Kprime, immigration and anagenesis parameters, all of which
modelled as time-dependent parameters.

Time dependency aims to capture the
effect of area changes islands undego from their emergence until subsidence.
Thus, oceanic, volcanic island ontogeny scenarios can be modelled (by a
beta function), as well as the effect of sea level fluctuations (modelled
through a sine function). See paramter entry \code{area_pars} for details.
Both island ontogeny and sea level fluctuations are allowed to operate
simultaneuosly.

This function also allows for the simulation of
non-oceanic islands, generating islands for which the starting condition
includes potential endemic and non-endemic species.
}
\references{
Valente, L.M., A.B. Phillimore and R.S. Etienne (2015).
Equilibrium and non-equilibrium dynamics simultaneously operate in the
Galapagos islands. Ecology Letters 18: 844-852.

Valente, L.M., Etienne, R.S. and Phillimore, A.B. (2014). The effects of
island ontogeny on species diversity and phylogeny.
Proceedings of the Royal Society B: Biological Sciences 281(1784),
p.20133227.
}
\seealso{
\code{\link{DAISIE_plot_sims}()} for plotting STT of simulation
outputs.

Other simulation models: 
\code{\link{DAISIE_sim_cr_shift}()},
\code{\link{DAISIE_sim_relaxed_rate}()},
\code{\link{DAISIE_sim}()}
}
\author{
Luis Valente and Albert Phillimore
}
\concept{simulation models}
\keyword{models}
