% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_check_format.R
\name{are_max_rates_gt_rates}
\alias{are_max_rates_gt_rates}
\title{Check if maximum rates are greater or equal to rates}
\usage{
are_max_rates_gt_rates(rates, max_rates)
}
\arguments{
\item{rates}{named list of numeric rates as returned by
\code{\link{update_rates}()}.}

\item{max_rates}{named list of numeric max rates as returned by
\code{\link{update_max_rates}()}.}
}
\value{
\code{TRUE} if maximum rates are greater or equal than rates,
\code{FALSE} otherwise.
}
\description{
Check if maximum rates are greater or equal to rates
}
\examples{
rates <- list(
  ext_rate = 0.1,
  immig_rate = 0.1,
  ana_rate = 0.1,
  clado_rate = 0.1
)
max_rates <- list(
  ext_max_rate = 1,
  immig_max_rate = 1,
  ana_max_rate = 1,
  clado_max_rate = 1
)
testthat::expect_true(
  DAISIE:::are_max_rates_gt_rates(
    rates = rates,
    max_rates = max_rates
  )
)
}
\seealso{
\code{\link{are_rates}}, \code{\link{are_max_rates}}
}
\author{
Joshua Lambert, Pedro Neves
}
\keyword{internal}
