% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{get_immig_rate_per_capita}
\alias{get_immig_rate_per_capita}
\title{Calculate per-capita immigration rate}
\usage{
get_immig_rate_per_capita(gam, num_spec, K, A = 1)
}
\arguments{
\item{gam}{A numeric with the per capita immigration rate.}

\item{num_spec}{A numeric with the current number of species.}

\item{K}{A numeric with carrying capacity.}

\item{A}{A numeric value for island area at a given point in time.}
}
\value{
A numeric with the per-capita immigration rate given A(t) and K.
}
\description{
This function is only called directly inside the RHS of the ontogeny
likelihood functions. In all other cases \code{\link{get_immig_rate}()} is to
be called instead.
}
\examples{
immig_rate_per_capita <- DAISIE:::get_immig_rate_per_capita(
  gam = 0.001,
  num_spec = 5,
  K = 20,
  A = 1000
)
}
\keyword{internal}
