% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomForestPredict.R
\name{randomForestPredict}
\alias{randomForestPredict}
\title{Random Forest Prediction}
\usage{
randomForestPredict(dataset = cs.in.dataset(),
  preds = cs.in.predictors(), robject = cs.in.Robject(),
  return.results = FALSE, ...)
}
\arguments{
\item{dataset}{[\code{\link{data.frame}}]\cr
Dataset with named columns. The names correspond to predictors and responses.}

\item{preds}{[\code{character}]\cr
Character vector of predictor variables.}

\item{robject}{[\code{list}]\cr
Named list of 
\code{\link[ranger]{ranger}}
objects set via Cornerstone menu "Input R Objects".}

\item{return.results}{[\code{logical(1)}]\cr
If \code{FALSE} the function returns \code{TRUE} invisibly.
If \code{TRUE}, it returns a \code{\link{list}} of results.
Default is \code{FALSE}.}

\item{...}{[ANY]\cr
Additional arguments to be passed to 
\code{\link[ranger]{ranger}}
. Please consider possible script variables (\code{scriptvars}) to prevent duplicates.}
}
\value{
Logical [\code{TRUE}] invisibly or, if \code{return.results = TRUE}, \code{\link{list}} of 
  resulting \code{\link{data.frame}} objects:
  \item{predictions}{
    Brushable dataset with predicted values for \code{dataset}. The original input and other
    columns can be added to this dataset through the menu \code{Columns -> Add from Parent ...}.
  }
}
\description{
Random Forest prediction via \code{\link[ranger]{predict.ranger}}. Predicts response variables
  from predictor variables, using \code{ranger} objects. All \code{ranger} objects have to work
  on the same set of prediction variables. These variables are exactly available in the
  prediction dataset. A response is not necessary, it will be predicted via this function.
}
\seealso{
\code{\link{randomForest}}
}
