% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/club.R
\name{club}
\alias{club}
\title{Find a club}
\usage{
club(X, dataCols, core, time_trim, HACmethod = c("FQSB", "AQSB"),
  cstar = 0)
}
\arguments{
\item{X}{matrix or dataframe containing data (preferably filtered data in order to remove business cycles)}

\item{dataCols}{integer vector with the column indices of the data}

\item{core}{an integer vector containing the id's of units in core group}

\item{time_trim}{a numeric value between 0 and 1, representing the portion of
time periods to trim when running log t regression model.
Phillips and Sul (2007, 2009) suggest to discard the first third of the period.}

\item{HACmethod}{string indicating whether a Fixed Quadratic Spheric Bandwidth (\code{HACmethod="FQSB"}) or
an Adaptive Quadratic Spheric Bandwidth (\code{HACmethod="AQSB"}) should be used for the truncation
of the Quadratic Spectral kernel in estimating the \eqn{log t} regression model
with heteroskedasticity and autocorrelation consistent standard errors.
The default method is "FQSB".}

\item{cstar}{numeric scalar, indicating the threshold value of the sieve criterion \eqn{c^*}
to include units in the detected core (primary) group (step 3 of Phillips and Sul (2007, 2009) clustering algorithm).
The default value is 0.}
}
\value{
A list of three objects: \code{id}, a vector containing the row indices
of club units in the original dataframe (input of function \code{findClubs});
\code{rows}, a vector of row indices of club units in the current dataset
(input of function \code{club}); \code{model}, a list containing information
about the model used to run the t-test on the units in the club.
}
\description{
Add units to core group according to step 3 of the clustering algorithm by
Phillips and Sul (2007, 2009), in order to find the enlarged club.
}
\references{
Phillips, P. C.; Sul, D., 2007. Transition modeling and econometric convergence tests. Econometrica 75 (6), 1771-1855.

Phillips, P. C.; Sul, D., 2009. Economic transition and growth. Journal of Applied Econometrics 24 (7), 1153-1185.
}
