/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.forms.builder.AbstractFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class PanelBuilder
extends AbstractFormBuilder {
    private static final String LABELED_BY_PROPERTY = "labeledBy";
    private static boolean labelForFeatureEnabledDefault = true;
    private static boolean opaqueDefault = false;
    private boolean labelForFeatureEnabled;
    private WeakReference mostRecentlyAddedLabelReference = null;

    public PanelBuilder(FormLayout layout) {
        this(layout, new JPanel(null));
    }

    public PanelBuilder(FormLayout layout, JPanel panel) {
        super(layout, panel);
        this.opaque(PanelBuilder.getOpaqueDefault());
        this.labelForFeatureEnabled = labelForFeatureEnabledDefault;
    }

    public static boolean getLabelForFeatureEnabledDefault() {
        return labelForFeatureEnabledDefault;
    }

    public static void setLabelForFeatureEnabledDefault(boolean b) {
        labelForFeatureEnabledDefault = b;
    }

    public static boolean getOpaqueDefault() {
        return opaqueDefault;
    }

    public static void setOpaqueDefault(boolean b) {
        opaqueDefault = b;
    }

    public final JPanel getPanel() {
        return (JPanel)this.getContainer();
    }

    @Deprecated
    public void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    @Deprecated
    public void setDefaultDialogBorder() {
        this.border(Borders.DIALOG);
    }

    @Deprecated
    public void setOpaque(boolean b) {
        this.getPanel().setOpaque(b);
    }

    public PanelBuilder background(Color background) {
        this.getPanel().setBackground(background);
        this.opaque(true);
        return this;
    }

    public PanelBuilder border(Border border) {
        this.getPanel().setBorder(border);
        return this;
    }

    public PanelBuilder border(String emptyBorderSpec) {
        this.border(Borders.createEmptyBorder(emptyBorderSpec));
        return this;
    }

    public PanelBuilder opaque(boolean b) {
        this.getPanel().setOpaque(b);
        return this;
    }

    public PanelBuilder labelForFeatureEnabled(boolean b) {
        this.labelForFeatureEnabled = b;
        return this;
    }

    public final JPanel build() {
        return this.getPanel();
    }

    public final JLabel addLabel(String textWithMnemonic) {
        return this.addLabel(textWithMnemonic, this.cellConstraints());
    }

    public final JLabel addLabel(String textWithMnemonic, CellConstraints constraints) {
        JLabel label = this.getComponentFactory().createLabel(textWithMnemonic);
        this.add((Component)label, constraints);
        return label;
    }

    public final JLabel addLabel(String textWithMnemonic, String encodedConstraints) {
        return this.addLabel(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JLabel addLabel(String textWithMnemonic, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        if (labelConstraints == componentConstraints) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using the CC class. See the JavaDocs for details.");
        }
        JLabel label = this.addLabel(textWithMnemonic, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    public final JLabel addROLabel(String textWithMnemonic) {
        return this.addROLabel(textWithMnemonic, this.cellConstraints());
    }

    public final JLabel addROLabel(String textWithMnemonic, CellConstraints constraints) {
        JLabel label = this.getComponentFactory().createReadOnlyLabel(textWithMnemonic);
        this.add((Component)label, constraints);
        return label;
    }

    public final JLabel addROLabel(String textWithMnemonic, String encodedConstraints) {
        return this.addROLabel(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JLabel addROLabel(String textWithMnemonic, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        PanelBuilder.checkConstraints(labelConstraints, componentConstraints);
        JLabel label = this.addROLabel(textWithMnemonic, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    public final JLabel addTitle(String textWithMnemonic) {
        return this.addTitle(textWithMnemonic, this.cellConstraints());
    }

    public final JLabel addTitle(String textWithMnemonic, CellConstraints constraints) {
        JLabel titleLabel = this.getComponentFactory().createTitle(textWithMnemonic);
        this.add((Component)titleLabel, constraints);
        return titleLabel;
    }

    public final JLabel addTitle(String textWithMnemonic, String encodedConstraints) {
        return this.addTitle(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JComponent addSeparator(String textWithMnemonic) {
        return this.addSeparator(textWithMnemonic, this.getLayout().getColumnCount());
    }

    public final JComponent addSeparator(String textWithMnemonic, CellConstraints constraints) {
        int titleAlignment = this.isLeftToRight() ? 2 : 4;
        JComponent titledSeparator = this.getComponentFactory().createSeparator(textWithMnemonic, titleAlignment);
        this.add((Component)titledSeparator, constraints);
        return titledSeparator;
    }

    public final JComponent addSeparator(String textWithMnemonic, String encodedConstraints) {
        return this.addSeparator(textWithMnemonic, new CellConstraints(encodedConstraints));
    }

    public final JComponent addSeparator(String textWithMnemonic, int columnSpan) {
        return this.addSeparator(textWithMnemonic, this.createLeftAdjustedConstraints(columnSpan));
    }

    public final JLabel add(JLabel label, CellConstraints labelConstraints, Component component, CellConstraints componentConstraints) {
        PanelBuilder.checkConstraints(labelConstraints, componentConstraints);
        this.add((Component)label, labelConstraints);
        this.add(component, componentConstraints);
        label.setLabelFor(component);
        return label;
    }

    @Override
    public Component add(Component component, CellConstraints cellConstraints) {
        Component result = super.add(component, cellConstraints);
        if (!this.labelForFeatureEnabled) {
            return result;
        }
        JLabel mostRecentlyAddedLabel = this.getMostRecentlyAddedLabel();
        if (mostRecentlyAddedLabel != null && this.isLabelForApplicable(mostRecentlyAddedLabel, component)) {
            this.setLabelFor(mostRecentlyAddedLabel, component);
            this.clearMostRecentlyAddedLabel();
        }
        if (component instanceof JLabel) {
            this.setMostRecentlyAddedLabel((JLabel)component);
        }
        return result;
    }

    protected boolean isLabelForApplicable(JLabel label, Component component) {
        if (label.getLabelFor() != null) {
            return false;
        }
        if (!component.isFocusable()) {
            return false;
        }
        if (!(component instanceof JComponent)) {
            return true;
        }
        JComponent c = (JComponent)component;
        return c.getClientProperty(LABELED_BY_PROPERTY) == null;
    }

    protected void setLabelFor(JLabel label, Component component) {
        Component labeledComponent;
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            labeledComponent = scrollPane.getViewport().getView();
        } else {
            labeledComponent = component;
        }
        label.setLabelFor(labeledComponent);
    }

    private JLabel getMostRecentlyAddedLabel() {
        if (this.mostRecentlyAddedLabelReference == null) {
            return null;
        }
        JLabel label = (JLabel)this.mostRecentlyAddedLabelReference.get();
        if (label == null) {
            return null;
        }
        return label;
    }

    private void setMostRecentlyAddedLabel(JLabel label) {
        this.mostRecentlyAddedLabelReference = new WeakReference<JLabel>(label);
    }

    private void clearMostRecentlyAddedLabel() {
        this.mostRecentlyAddedLabelReference = null;
    }

    private static void checkConstraints(CellConstraints c1, CellConstraints c2) {
        Preconditions.checkArgument((c1 != c2 ? 1 : 0) != 0, (String)"You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using the CC factory. See the JavaDocs for details.");
    }
}

