% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/on.torus.R
\name{on.torus}
\alias{on.torus}
\title{Transform the angular data to be on principal interval}
\usage{
on.torus(x)
}
\arguments{
\item{x}{d-dimensional angular data(vector or matrix) whose unit is the radian.}
}
\value{
d-dimensional radian-unit angular data on \eqn{[0, 2\pi)^d}.
}
\description{
\code{on.torus} transforms d-dimensional angular data
  to be on \eqn{[0, 2\pi)^d}.
}
\examples{
data <- SARS_CoV_2$tbl[1:200, 1:2]
data <- data * pi / 180

on.torus(data)
}
