% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFModel.R
\name{RFModel}
\alias{RFModel}
\title{RandomForest Model for Searching Similar Cases}
\description{
RandomForest Model for Searching Similar Cases

RandomForest Model for Searching Similar Cases
}
\details{
This class uses the proximity or depth matrix of the RandomForest algorithm 
as a similarity matrix of training and query 
observations. By default all cases with at least one missing values are dropped 
from learning, calculating the distance matrix and searching for similar
cases.
}
\references{
Englund and Verikas. A novel approach to estimate proximity in a random 
forest: An exploratory study.
}
\section{Super class}{
\code{\link[CaseBasedReasoning:CBRBase]{CaseBasedReasoning::CBRBase}} -> \code{RFModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{the statistical model}

\item{\code{model_params}}{model arguments}

\item{\code{dist_method}}{Distance method}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RFModel-print}{\code{RFModel$print()}}
\item \href{#method-RFModel-new}{\code{RFModel$new()}}
\item \href{#method-RFModel-fit}{\code{RFModel$fit()}}
\item \href{#method-RFModel-set_distance_method}{\code{RFModel$set_distance_method()}}
\item \href{#method-RFModel-clone}{\code{RFModel$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="CBRBase" data-id="calc_distance_matrix"><a href='../../CaseBasedReasoning/html/CBRBase.html#method-CBRBase-calc_distance_matrix'><code>CaseBasedReasoning::CBRBase$calc_distance_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CaseBasedReasoning" data-topic="CBRBase" data-id="get_similar_cases"><a href='../../CaseBasedReasoning/html/CBRBase.html#method-CBRBase-get_similar_cases'><code>CaseBasedReasoning::CBRBase$get_similar_cases()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFModel-print"></a>}}
\if{latex}{\out{\hypertarget{method-RFModel-print}{}}}
\subsection{Method \code{print()}}{
Prints information of the initialized object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFModel$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-RFModel-new}{}}}
\subsection{Method \code{new()}}{
Initialize a RandomForest object for searching similar cases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFModel$new(formula, data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{Object of class formula or character describing the model fit.}

\item{\code{data}}{Training data of class data.frame}

\item{\code{...}}{ranger RandomForest arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFModel-fit"></a>}}
\if{latex}{\out{\hypertarget{method-RFModel-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the RandomForest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFModel$fit()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Training data of class data.frame}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFModel-set_distance_method"></a>}}
\if{latex}{\out{\hypertarget{method-RFModel-set_distance_method}{}}}
\subsection{Method \code{set_distance_method()}}{
Set the distance method. Available are Proximity and Depth
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFModel$set_distance_method(method = "Depth")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Distance calculation method (default: Proximity)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RFModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
