% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/constraints.R
\docType{methods}
\name{==,Expression,Expression-method}
\alias{==,Expression,Expression-method}
\alias{==,Expression,ConstVal-method}
\alias{==,ConstVal,Expression-method}
\alias{EqConstraint-class}
\alias{.EqConstraint}
\alias{EqConstraint}
\alias{EqConstraint}
\alias{is_dcp,EqConstraint-method}
\alias{residual,EqConstraint-method}
\alias{canonicalize,EqConstraint-method}
\title{The EqConstraint class.}
\usage{
\S4method{==}{Expression,Expression}(e1, e2)

\S4method{==}{Expression,ConstVal}(e1, e2)

\S4method{==}{ConstVal,Expression}(e1, e2)

EqConstraint(lh_exp, rh_exp)

\S4method{is_dcp}{EqConstraint}(object)

\S4method{residual}{EqConstraint}(object)

\S4method{canonicalize}{EqConstraint}(object)
}
\arguments{
\item{e1, e2}{The \linkS4class{Expression} objects or numeric constants to compare.}

\item{lh_exp}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the left-hand side of the inequality.}

\item{rh_exp}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the right-hand side of the inequality.}

\item{object}{An \linkS4class{EqConstraint} object.}
}
\description{
This class represents a equality constraint.
}
\section{Methods (by generic)}{
\itemize{
\item \code{is_dcp}: The constraint is DCP if the left-hand and right-hand expressions are affine.

\item \code{residual}: The absolute value of the left-hand minus the right-hand expression, i.e. \code{abs(lh_exp - rh_exp)}.

\item \code{canonicalize}: The graph implementation of the object. Marks the top level constraint as the \code{dual_holder} so the dual value will be saved to the \linkS4class{EqConstraint}.
}}

\section{Slots}{

\describe{
\item{\code{constr_id}}{(Internal) A unique integer identification number used internally.}

\item{\code{lh_exp}}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the left-hand side of the inequality.}

\item{\code{rh_exp}}{An \linkS4class{Expression}, numeric element, vector, or matrix representing the right-hand side of the inequality.}

\item{\code{args}}{(Internal) A list that holds \code{lh_exp} and \code{rh_exp} for internal use.}

\item{\code{.expr}}{(Internal) An \linkS4class{Expression} representing \code{lh_exp - rh_exp} for internal use.}

\item{\code{dual_variable}}{(Internal) A \linkS4class{Variable} representing the dual variable associated with the constraint.}
}}

