% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicub.R
\name{multicub}
\alias{multicub}
\title{Joint plot of estimated CUB models in the parameter space}
\usage{
multicub(listord,mvett,csiplot=FALSE,paiplot=FALSE,...)
}
\arguments{
\item{listord}{A data matrix, data frame, or list of vectors of ordinal observations (for variables 
with different number of observations)}

\item{mvett}{Vector of number of categories for ordinal variables in \code{listord} (optional: if missing, 
the number of categories is retrieved from data: it is advisable to specify it in case some category has zero 
frequency)}

\item{csiplot}{Logical: should \eqn{\xi} or \eqn{1-\xi} be the \eqn{y} coordinate}

\item{paiplot}{Logical: should \eqn{\pi} or \eqn{1-\pi} be the \eqn{x} coordinate}

\item{...}{Additional arguments to be passed to \code{\link{plot}}, \code{\link{text}}, and \code{\link{GEM}}}
}
\value{
Fit a CUB model to list elements, and then by default it returns a plot of the estimated 
\eqn{(1-\pi, 1-\xi)} as points in the parameter space. Depending on \code{csiplot} and \code{paiplot} 
and on desired output, \eqn{x} and \eqn{y} coordinates may be set to \eqn{\pi} and \eqn{\xi}, respectively.
}
\description{
Return a plot of estimated CUB models represented as points in the parameter space.
}
\examples{
data(univer)
listord<-univer[,8:12]
multicub(listord,colours=rep("red",5),cex=c(0.4,0.6,0.8,1,1.2),
  pch=c(1,2,3,4,5),xlim=c(0,0.4),ylim=c(0.75,1),pos=c(1,3,3,3,3))
###############################
m1<-5; m2<-7;  m3<-9
pai<-0.7;csi<-0.6
n1<-1000; n2<-500; n3<-1500
ord1<-simcub(n1,m1,pai,csi)
ord2<-simcub(n2,m2,pai,csi)
ord3<-simcub(n3,m3,pai,csi)
listord<-list(ord1,ord2,ord3)
multicub(listord,labels=c("m=5","m=7","m=9"),pos=c(3,1,4))
}
\keyword{device}
