% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubecsi.R
\name{cubecsi}
\alias{cubecsi}
\title{Main function for CUBE models with covariates only for feeling}
\usage{
cubecsi(m, ordinal, W, starting, maxiter, toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of selected covariates for explaining the feeling component}

\item{starting}{Vector of initial parameters estimates to start the optimization algorithm, with length equal to
NCOL(W) + 3 to account for an intercept term for the feeling component (first entry)}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}
}
\value{
An object of the class "CUBE". For cubecsi, $niter will return a NULL value since the optimization procedure
 is not iterative but based on "optim" (method = "L-BFGS-B", option hessian=TRUE). \cr $varmat will return the inverse 
 of the numerically computed Hessian when it is positive definite, otherwise the procedure will return a matrix of NA
  entries.
}
\description{
Estimate and validate a CUBE model for ordinal data, with covariates only for explaining the
feeling component.
}
\examples{
### Applying \donttest option since the proposed examples require a long run time for check 
\donttest{
data(relgoods)
m=10
ordinal=relgoods[,37]
age=2014-relgoods[,4]
lage=log(age)-mean(log(age))
nona=na.omit(cbind(ordinal,lage))
ordinal=nona[,1]
W=nona[,2]
starting=rep(0.1,4)     
fit=cubecsi(m, ordinal, W, starting, maxiter=100, toler=1e-3)
param=fit$estimates
pai=param[1]                        ## ML estimates for the uncertainty parameter
gama=param[2:(length(param)-1)]     ## ML estimates for the coefficients of the feeling covariates
phi=param[length(param)]            ## ML estimates for the overdispersion parameter
loglik=fit$loglik
varmat=fit$varmat
BIC=fit$BIC
##########################################################
data(univer)
m<-7 
ordinal=univer[,8]
gender=univer[,4]
initial=inibestcube(m,ordinal)
starting=inibestcubecsi(m,ordinal,W=gender,initial,maxiter=500,toler=1e-6)
fitcsi=cubecsi(m, ordinal, W=gender, starting, maxiter=100, toler=1e-3)
param=fitcsi$estimates
pai=param[1]                       ## ML estimates for the uncertainty parameter
gama=param[2:(length(param)-1)]    ## ML estimates for the coefficients of the feeling covariates
phi=param[length(param)]           ## ML estimates for the overdispersion parameter
loglik=fitcsi$loglik
varmat=fitcsi$varmat
BIC=fitcsi$BIC
}
}
\seealso{
\code{\link{loglikcubecsi}},  \code{\link{inibestcubecsi}},  \code{\link{CUBE}}
}
\keyword{#models}
\keyword{internal}

