% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_cste_surv.R
\name{select_cste_surv}
\alias{select_cste_surv}
\title{Select the optimal tuning parameters in CSTE estimation for time to event outcome with right censoring.}
\usage{
select_cste_surv(
  x,
  y,
  z,
  status = NULL,
  lam_seq,
  beta_ini = NULL,
  nknots = 1,
  max.iter = 2000,
  eps = 0.001
)
}
\arguments{
\item{x}{samples of covariates which is a \eqn{n*p} matrix.}

\item{y}{samples of binary outcome which is a \eqn{n*1} vector.}

\item{z}{samples of treatment indicator which is a \eqn{n*1} vector.}

\item{status}{samples of censoring indicator which is a \eqn{n*1} vector. 
Default value is NULL, indicating no censoring.}

\item{lam_seq}{a sequence for the choice of \eqn{\lambda}.}

\item{beta_ini}{initial values for \eqn{(\beta_1', \beta_2')'}, default value is NULL.}

\item{nknots}{number of knots for the B-spline for estimating \eqn{g_1} and \eqn{g_2}.}

\item{max.iter}{maximum iteration for the algorithm.}

\item{eps}{numeric scalar \eqn{\geq} 0, the tolerance for the estimation 
of \eqn{\beta_1} and \eqn{\beta_2}.}
}
\value{
A list which includes
\itemize{
   \item \code{optimal}: optimal cste within the given the sequence of \eqn{\lambda}.
   \item \code{bic}: BIC for the sequence of \eqn{\lambda}.
   \item \code{lam_seq}: the sequence of \eqn{\lambda} that is used.
   
}
}
\description{
select lasso penalty parameter \eqn{\lambda} for \eqn{\beta_1} and
\eqn{\beta_2} in CSTE estimation.
}
\references{
Ma Y. and Zhou X. (2017). 
Treatment selection in a randomized clinical trial via covariate-specific 
treatment effect curves, \emph{Statistical Methods in Medical Research}, 26(1), 124-141.
}
\seealso{
\code{\link{cste_surv}}
}
