% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformers.R
\name{financial_cof_transformers}
\alias{financial_cof_transformers}
\title{Financial cost of Failure for Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_transformers(
  tf_asset_category,
  type_financial_factor_size = NULL,
  type_financial_factor_kva_mva = NULL,
  access_factor_criteria
)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer asset category
Options: \code{tf_asset_category = c("6.6/11kV Transformer (GM)",
"20kV Transformer (GM)", "33kV Transformer (GM)", "66kV Transformer (GM) "
"132kV Transformer (GM) ")}.}

\item{type_financial_factor_size}{String The type financial factor size for Transformer}

\item{type_financial_factor_kva_mva}{Numeric The type financial factor kVA MVA for Transformer}

\item{access_factor_criteria}{String. Asses Financial factor criteria for Transformer
setting (cf. table 221, page 180, CNAIM, 2021).}
}
\value{
Numeric. Financial consequences of failure for Transformer
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_transformers(tf_asset_category = "33kV Transformer (GM)",
type_financial_factor_size = "33/20kV, CMR equivalent",
type_financial_factor_kva_mva = 20,
access_factor_criteria = "Type A")
}
