% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_append_fs.R
\name{CGGP_internal_calcMSEde}
\alias{CGGP_internal_calcMSEde}
\title{Calculate MSE over blocks}
\usage{
CGGP_internal_calcMSEde(valsinds, MSE_MAP)
}
\arguments{
\item{valsinds}{Block levels to calculate MSEs for}

\item{MSE_MAP}{Matrix of MSE values}
}
\value{
All MSE values
}
\description{
Delta of adding block is product over i=1..d of IMSE(i,j-1) - IMSE(i,j)
}
\examples{
SG <- CGGPcreate(d=3, batchsize=100)
y <- apply(SG$design, 1, function(x){x[1]+x[2]^2})
SG <- CGGPfit(SG, Y=y)
MSE_MAP <- outer(1:SG$d, 1:8, 
     Vectorize(function(dimlcv, lcv1) {
        CGGP_internal_calcMSE(SG$xb[1:SG$sizest[dimlcv]],
        theta=SG$thetaMAP[(dimlcv-1)*SG$numpara+1:SG$numpara],
        CorrMat=SG$CorrMat)
 }))
CGGP_internal_calcMSEde(SG$po[1:SG$poCOUNT, ], MSE_MAP)
}
