% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEDA.R
\name{calculateGenePval}
\alias{calculateGenePval}
\title{Calculating gene level p-values using modified robust rank aggregation
(alpha-RRA method) on sgRNAs' p-values}
\usage{
calculateGenePval(pvec, genes, alpha)
}
\arguments{
\item{pvec}{A numeric vector containing p-values of sgRNAs.}

\item{genes}{A character string containing gene names corresponding 
to sgRNAs.}

\item{alpha}{A numeric number denoting the alpha cutoff (i.e. 0.05).}
}
\value{
A list with four elements: 1) a list of genes with their p-values; 
  2) a numeric matrix of rho null, each column corresponding to a different 
  number of sgRNAs per gene; 3)a numeric vector of rho; 4) a numeric vector 
  of number of sgRNAs per gene.
}
\description{
Code was adapted from R package gscreend. The alpha-RRA method is 
adapted from MAGeCK.
}
