\name{plotcomp}
\alias{plotcomp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot Promoter Composition Data
}
\description{
plotcomp generates a plot for a user-specified gene displaying its promoter composition together with its expression levels in the various conditions being compared. A gene model together with known ENSEMBL transcripts and their spatial relation to the promoter regions is also displayed. 
}
\usage{
plotcomp(x, gene, anot_list)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
DGEList object from pool() function call. 
}
  \item{gene}{
character. Gene name that is present in the pooled DGEList object. 
}
 \item{anot_list}{
list. List that contains the gene annotation data as output by running \code{prepEnsemblAnot} .
}
}
\details{
For this function to work, gene annotation data should be downloaded and make available using \code{getEnsemblAnot} and \code{prepEnsemblAnot}. This plot consists of several sections. The first is a dendrogram clustering the different conditions by promoter composition. Next to it is a plot with promoter composition displayed, with each promoter shaded in a different color. The size of each block corresponds to the proportion of transcription that occurs from that promoter relative to all transcription from all promoter regions defined for this gene. The next block displays gene-level expression as quantified by summing across all gene-related specified promoter regions, relative to the total number of tags generated by this library (measured in tags per million or tpm). Finally, at the bottom of the plot is a gene model, displaying how the specified promoter regions align with known ENSEMBL transcripts. The relative importance of each promoter region is highlighted by colored bars over those regions, with higher bars implying more heavily transcribed promoter regions as compared to the others. 
}
\value{
character. This function returns a character vector of promoter names that correspond to this gene in decreasing order of total expression. }
\references{
 ~put references to the literature/web site here ~
}
\author{
Emmanuel Dimont - Hide Laboratory for Computational Biology. Department of Biostatistics. Harvard School of Public Health. (edimont@mail.harvard.edu)
}
\note{
ENSEMBL data corresponds to the latest hg19 human genome build. No other genome builds are currently supported. Due to the large size of the database, the plotting function can take a few seconds to finish drawing. 
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{countTags}},\code{\link{definePromoters}},\code{\link{pool}},\code{\link{diffcomp}},\code{\link{plotcomp}},\code{\link{html.report}},\code{\link{DGEList}},\code{\link{getEnsemblAnot}},\code{\link{prepEnsemblAnot}}
}
\examples{
\dontrun{

Ensembl_list = getEnsemblAnot() #this can take 10 minutes
anot.tabs = prepEnsemblAnot(Ensembl_list)
save(anot.tabs,file="anot.tabs.RData") #save for future use
load("anot.tabs.RData") #faster to load than to download fresh each time

data(mcf7a549.raw.counts.F5)
annotations = osc2info(mcf7a549.raw.counts.F5$counts$region)
my.ids <- c("a549.1", "a549.2", "mcf7.1", "mcf7.2")

my.data = DGEList(
	counts = mcf7a549.raw.counts.F5$counts[,-c(1,2),with=FALSE], #remove columns 1&2
	lib.size = mcf7a549.raw.counts.F5$depth,
	group = my.ids, #will not pool replicates
	#group = c("a549","a549","mcf7","mcf7"), #pools replicates
	#group = Select(my.ids,".",1), #pools replicates (alternative)
	genes = data.frame(
	chr = annotations$chr,
	strand = annotations$strand,
	start = annotations$start,
	end = annotations$end,
	gene = mcf7a549.raw.counts.F5$counts$gene
),
	remove.zeros = FALSE
)

#OPTIONALLY prior to pooling:
#Normalize samples
my.data = calcNormFactors(my.data)
#Estimate negative binomial dispersion (common or tagwise)
my.data = estimateCommonDisp(my.data, verbose = T)
my.data = estimateTagwiseDisp(my.data)

#Finally pool the DGEList object
data.pooled = pool(my.data)

#Make plot
plotcomp(data.pooled,"SYT1",anot.tabs)
}}
