% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceBLB.R
\name{performanceBLB}
\alias{performanceBLB}
\title{Performance comparison of severals estimation algorithms}
\usage{
performanceBLB(xi, k = 2, L = 0, method = NULL, maxit = NULL)
}
\arguments{
\item{xi}{Binary matrix.}

\item{k}{Dimensions number. By default \code{k = 2}.}

\item{L}{Penalization parameter. By default \code{L = 0}.}

\item{method}{use value 1 for algorithms without gradient, 2 with gradient, 3 quasi-newton methods or 4 for all methods. By default \code{method = 2}.}

\item{maxit}{The maximum number of iterations. Defaults to 100 for the gradient methods, and 500 without gradient.}
}
\value{
data frame with method, time of process, convergence and number of evaluations
}
\description{
This function computes the estimates of A and B matrix with severals algorithms.
}
\details{
This function compare the process time and convergence of different algorithms without gradient, with gradient or quasi-newton method for estimating the parameters in a Binary Logistic Biplot
}
\examples{
\donttest{
data('Methylation')
set.seed(123456)
########### Gradient Methods
performanceBLB(xi = Methylation)
performanceBLB(xi = Methylation, maxit = 150)

########### Without Gradient Methods
performanceBLB(xi = Methylation, method = 1)
performanceBLB(xi = Methylation, method = 1, maxit = 100)

########### Quasi-Newton Methods
performanceBLB(xi = Methylation, method = 3)
performanceBLB(xi = Methylation, method = 3, maxit = 100)

########### All methods
performanceBLB(x = Methylation, method = 4)
}
}
\references{
John C. Nash (2011). Unifying Optimization Algorithms to Aid Software System Users:optimx for R. Journal of Statistical Software. 43(9). 1--14.

John C. Nash (2014). On Best Practice Optimization Methods in R. Journal of Statistical Software. 60(2). 1--14.

Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{gradientDesc}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
