% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExpression.R
\name{plotExpression}
\alias{plotExpression}
\title{Plot the expression signal of individual genes}
\usage{
plotExpression(exprmat, gene, series, peakdet)
}
\arguments{
\item{exprmat}{A numeric matrix with expression series data with variables as rownames.}

\item{gene}{A character string (not case-sensitive) defining the gene to be plotted.}

\item{series}{A numeric vector defining the experimental series (e.g. time-points of sample acquisition).}

\item{peakdet}{A list returned by the peakDetection function.}
}
\value{
This function does not return any value but generates a plot.
}
\description{
This function plots the expression signal of a defined gene and marks the main peak location with a dashed line.
}
\examples{
# Example based on the heat-shock dataset
data(heat)
heat = as.matrix(heat)
# Define series
series <- c(37,40,41,42,43)
# Run the peak detection algorithm
peakdet <- peakDetection(heat, series, type ='rnaseq', actstrength = 1.5,
prominence = 1.3, minexpr = 5000)
# Plot the expression signal of the gene CXCL5
plotExpression(heat, 'CXCL5', series, peakdet)

}
\author{
David Lauenstein
}
