% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_func.R
\name{two.grp.random.a0}
\alias{two.grp.random.a0}
\title{Model fitting for two groups (treatment and control group, no covariates) with random a0}
\usage{
two.grp.random.a0(
  data.type,
  y.c,
  n.c,
  v.c,
  historical,
  prior.mu.c.shape1 = 1,
  prior.mu.c.shape2 = 1,
  prior.a0.shape1 = 1,
  prior.a0.shape2 = 1,
  lower.limits = rep(0, 10),
  upper.limits = rep(1, 10),
  slice.widths = rep(0.1, 10),
  nMC = 10000,
  nBI = 250
)
}
\arguments{
\item{data.type}{Character string specifying the type of response. The options are "Normal", "Bernoulli", "Poisson" and "Exponential".}

\item{y.c}{Sum of responses for the control group.}

\item{n.c}{Sample size of the control group.}

\item{v.c}{(For normal data only) variance of responses for the control group.}

\item{historical}{Matrix of historical dataset(s). If \code{data.type} is "Normal", \code{historical} is a matrix with three columns:
\itemize{
\item The first column contains the sum of responses for the control group.
\item The second column contains the sample size of the control group.
\item The third column contains the variance of responses for the control group.
}
For all other data types, \code{historical} is a matrix with two columns:
\itemize{
\item The first column contains the sum of responses for the control group.
\item The second column contains the sample size of the control group.
}
Each row represents a historical dataset.}

\item{prior.mu.c.shape1}{First hyperparameter of the initial prior for \eqn{\mu_c}. The default is 1. Does not apply if \code{data.type} is "Normal".}

\item{prior.mu.c.shape2}{Second hyperparameter of the initial prior for \eqn{\mu_c}. The default is 1. Does not apply if \code{data.type} is "Normal".}

\item{prior.a0.shape1}{First shape parameter of the beta prior for \eqn{a_0}. The default is 1.}

\item{prior.a0.shape2}{Second shape parameter of the beta prior for \eqn{a_0}. The default is 1.}

\item{lower.limits}{Vector of lower limits for parameters to be used by the slice sampler. The length of the vector should be equal to the number of historical datasets. The default is 0 for all parameters (may not be appropriate for all situations).}

\item{upper.limits}{Vector of upper limits for parameters to be used by the slice sampler. The length of the vector should be equal to the number of historical datasets. The default is 1 for all parameters (may not be appropriate for all situations).}

\item{slice.widths}{Vector of initial slice widths used by the slice sampler. The length of the vector should be equal to the number of historical datasets. The default is 0.1 for all parameter (may not be appropriate for all situations).}

\item{nMC}{Number of iterations (excluding burn-in samples) for the slice sampler or Gibbs sampler. The default is 10,000.}

\item{nBI}{Number of burn-in samples for the slice sampler or Gibbs sampler. The default is 250.}
}
\value{
If \code{data.type} is "Normal", posterior samples of \eqn{\mu_c}, \eqn{\tau} and \eqn{a_0} are returned.
For all other data types, posterior samples of \eqn{\mu} and \eqn{a_0} are returned. If there are \eqn{K} historical datasets,
then \eqn{a_0 = (a_{01},\cdots,a_{0K})}.
}
\description{
Model fitting using normalized power priors for two groups (treatment and control group, no covariates) with random \eqn{a_0}
}
\details{
If \code{data.type} is "Bernoulli", "Poisson" or "Exponential", a single response from the treatment group is assumed to follow Bern(\eqn{\mu_t}), Pois(\eqn{\mu_t}) or Exp(rate=\eqn{\mu_t}), respectively,
where \eqn{mu_t} is the mean of responses for the treatment group. If \code{data.type} is "Normal", a single response from the treatment group is assumed to follow \eqn{N(\mu_t, \tau^{-1})}
where \eqn{\tau} is the precision parameter.
The distributional assumptions for the control group data are analogous.

If \code{data.type} is "Bernoulli", the initial prior for \eqn{\mu_t} is beta(\code{prior.mu.t.shape1}, \code{prior.mu.t.shape2}).
If \code{data.type} is "Poisson", the initial prior for \eqn{\mu_t} is Gamma(\code{prior.mu.t.shape1}, rate=\code{prior.mu.t.shape2}).
If \code{data.type} is "Exponential", the initial prior for \eqn{\mu_t} is Gamma(\code{prior.mu.t.shape1}, rate=\code{prior.mu.t.shape2}).
The initial priors used for the control group data are analogous.

If \code{data.type} is "Normal", historical datasets are assumed to have the same precision parameter \eqn{\tau} as the current dataset for computational simplicity.
The initial prior for \eqn{\tau} is the Jeffery's prior, \eqn{\tau^{-1}}. The initial prior for the \eqn{\mu_c} is the uniform improper prior.
Posterior samples of \eqn{\mu_c} and \eqn{\tau} are obtained through Gibbs sampling.

Posterior samples of \eqn{a_0} are obtained through slice sampling. The default lower limits for the parameters are 0. The default upper limits
for the parameters are 1.  The default slice widths for the parameters are 0.1.
The defaults may not be appropriate for all situations, and the user can specify the appropriate limits
and slice width for each parameter.
}
\examples{

data.type <- "Bernoulli"
y.c <- 70
n.c <- 100

# Simulate three historical datasets
historical <- matrix(0, ncol=2, nrow=3)
historical[1,] <- c(70, 100)
historical[2,] <- c(60, 100)
historical[3,] <- c(50, 100)

# Set parameters of the slice sampler
lower.limits <- rep(0, 3) # The dimension is the number of historical datasets
upper.limits <- rep(1, 3)
slice.widths <- rep(0.1, 3)

result <- two.grp.random.a0(data.type=data.type, y.c=y.c, n.c=n.c, historical=historical,
                            lower.limits=lower.limits, upper.limits=upper.limits,
                            slice.widths=slice.widths, nMC=10000, nBI=250)
}
\references{
Neal, Radford M. Slice sampling. Ann. Statist. 31 (2003), no. 3, 705--767.
}
\seealso{
\code{\link{power.two.grp.random.a0}}
}
