% Generated by roxygen2 (4.0.0): do not edit by hand
\name{MclustHODC}
\alias{MclustHODC}
\title{Hierachical Ordered Density Clustering (HODC) for Finite Mixture Model Fitting}
\description{
This function implements the HODC algorithm for density estimates by a finite mixture of normals model which is implemented by function "Mclust" in R package \strong{mclust}.  
}
\usage{
MclustHODC(pvalue)
}
\arguments{
\item{pvalue}{a vector of p-valuesobtained from large scale statistical hypothesis testing}
}
\value{
a list of density clustering results by the HODC algorithm
\describe{
\item{mean}{mean estimates of unimportant and important clusters}
\item{variance}{variance estimates of unimportant and important clusters}
\item{pro}{probability estiamtes of unimportant and important clusters}
\item{classificaiton}{classifications configrations}
}
}



\details{
This function calls Mclust to estimate the marginal density of the testing statistics \strong{r}, converted from p-values, using a mixture of normal densities without incoorporating the network information. Futhermore, it implements the HODC algorithm to classify density components into two clusters. We refer to them as the unimportant cluster and the important cluster, where the important cluster has a larger mean than the unimportant cluster.
}
\references{
Yize Zhao, Jian Kang, Tianwei Yu (2014) A Bayesian nonparameteric model for selecting gene and gene subnetwork, Annals of Applied Statistics, in press. 

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BayesNetDiscovery: an R package for network identifications via Bayesian nonparametric mixture models, working paper.

}
\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao
}


\examples{
rstat=c(rnorm(50,mean=1),rnorm(50,mean=2),rnorm(100,mean=4),rnorm(100,mean=8))
pvalue=pnorm(-rstat)
mclustHODC=MclustHODC(pvalue)
}

