% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.BayesMallows.R
\name{plot.BayesMallows}
\alias{plot.BayesMallows}
\title{Plot Posterior Distributions}
\usage{
\method{plot}{BayesMallows}(x, burnin = x$burnin, parameter = "alpha",
  items = NULL, ...)
}
\arguments{
\item{x}{An object of type \code{BayesMallows}, returned from
\code{\link{compute_mallows}}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{x$burnin}, and must be
provided if \code{x$burnin} does not exist. See \code{\link{assess_convergence}}.}

\item{parameter}{Character string defining the parameter to plot. Available
options are \code{"alpha"}, \code{"rho"}, \code{"cluster_probs"},
\code{"cluster_assignment"}, and \code{"theta"}.}

\item{items}{The items to study in the diagnostic plot for \code{rho}. Either
a vector of item names, corresponding to \code{x$items} or a
vector of indices. If NULL, five items are selected randomly.
Only used when \code{parameter = "rho"}.}

\item{...}{Other arguments passed to \code{plot} (not used).}
}
\description{
Plot posterior distributions of the parameters of the Mallows Rank model.
}
\examples{
# The example datasets potato_visual and potato_weighing contain complete
# rankings of 20 items, by 12 assessors. We first analyse these using the Mallows
# model:
model_fit <- compute_mallows(potato_visual)

# Se the documentation to compute_mallows for how to assess the convergence
# of the algorithm
# We set the burnin = 1000
model_fit$burnin <- 1000
# By default, the scale parameter "alpha" is plotted
plot(model_fit)
\dontrun{
  # We can also plot the latent rankings "rho"
  plot(model_fit, parameter = "rho")
  # By default, a random subset of 5 items are plotted
  # Specify which items to plot in the items argument.
  plot(model_fit, parameter = "rho",
       items = c(2, 4, 6, 9, 10, 20))
  # When the ranking matrix has column names, we can also
  # specify these in the items argument.
  # In this case, we have the following names:
  colnames(potato_visual)
  # We can therefore get the same plot with the following call:
  plot(model_fit, parameter = "rho",
       items = c("P2", "P4", "P6", "P9", "P10", "P20"))
  }

\dontrun{
  # Plots of mixture parameters:
  # We can run a mixture of Mallows models, using the n_clusters argument
  # We use the sushi example data. See the documentation of compute_mallows for a more elaborate
  # example
  model_fit <- compute_mallows(sushi_rankings, n_clusters = 5, save_clus = TRUE)
  model_fit$burnin <- 1000
  # We can then plot the posterior distributions of the cluster probabilities
  plot(model_fit, parameter = "cluster_probs")
  # We can also get a cluster assignment plot, showing the assessors along the horizontal
  # axis and the clusters along the vertical axis. The color show the probability
  # of belonging to each clusters. The assessors are sorted along the horizontal
  # axis according to their maximum a posterior cluster assignment. This plot
  # illustrates the posterior uncertainty in cluster assignments.
  plot(model_fit, parameter = "cluster_assignment")
  # See also ?assign_cluster for a function which returns the cluster assignment
  # back in a dataframe.
}




}
