% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bd.R
\name{bd}
\alias{bd}
\title{Ball Divergence}
\usage{
bd(x, y = NULL, dst = FALSE, size = NULL, num.threads = 2,
  kbd.type = "sum")
}
\arguments{
\item{x}{a numeric vector, matrix, data.frame, \code{dist} object or list contains vector, matrix or data.frame.}

\item{y}{a numeric vector, matrix or data.frame.}

\item{dst}{if \code{dst = TRUE}, x will be considered as a distance matrix. Default: \code{dst = FALSE}}

\item{size}{a vector record sample size of each group.}

\item{num.threads}{Number of threads. Default \code{num.threads = 2}.}

\item{kbd.type}{the type of K-sample test statistics. Setting \code{kbd.type = "sum"} print the statistic 
and \eqn{p}-value of the summation version of \eqn{K} sample ball divergence while setting \code{kbd.type = "max"} print
the maximum version. Further, you can obtain the information of both summation and maximum by \code{summary} function.}
}
\value{
\item{\code{bd }}{ sample version of ball divergence}
}
\description{
Compute ball divergence statistic between two-sample or K-sample.
}
\details{
Given the samples not containing missing values, \code{bd} returns sample version of ball divergence.
If we set \code{dst = TRUE}, arguments \code{x}, \code{y} can be a \code{dist} object or a
symmetric numeric matrix recording distance between samples; 
otherwise, these arguments are treated as data.

Ball divergence, introduced by Pan et al(2017), is a new concept to measure the difference 
between two probability distributions in separable Banach space. 
Ball divergence of two probability measures is proven to be zero if and only if they are identical.

The definitions of the sample version ball divergence are as follows.
Given two independent samples \eqn{ \{x_{1}, ..., x_{n}\} } with the associated probability measure \eqn{\mu} and 
\eqn{ \{y_{1}, ..., y_{m}\} } with \eqn{\nu}, where the observations in each sample are \emph{i.i.d}.

Also, let \eqn{\delta(x,y,z)=I(z\in \bar{B}(x, \rho(x,y)))}, 
where \eqn{\delta(x,y,z)} indicates whether \eqn{z} is located in the closed ball \eqn{\bar{B}(x, \rho(x,y))} 
with center \eqn{x} and radius \eqn{\rho(x, y)}. 
We denote:
\deqn{
A_{ij}^{X}=\frac{1}{n}\sum_{u=1}^{n}{\delta(X_i,X_j,X_u)}, \quad A_{ij}^{Y}=\frac{1}{m}\sum_{v=1}^{m}{\delta(X_i,X_j,Y_v)}
}
\deqn{
C_{kl}^{X}=\frac{1}{n}\sum_{u=1}^{n}{\delta(Y_k,Y_l,X_u)}, \quad C_{kl}^{Y}=\frac{1}{m}\sum_{v=1}^{m}{\delta(Y_k,Y_l,Y_v)}
}

\eqn{A_{ij}^X} represents the proportion of samples \eqn{ \{x_{1}, ..., x_{n}\} } located in the 
ball \eqn{\bar{B}(X_i,\rho(X_i,X_j))} and \eqn{A_{ij}^Y} represents the proportion of samples \eqn{ \{y_{1}, ..., y_{m}\} } 
located in the ball \eqn{\bar{B}(X_i,\rho(X_i,X_j))}. 
Meanwhile, \eqn{C_{kl}^X} and \eqn{C_{kl}^Y} 
represent the corresponding proportions located in the ball \eqn{\bar{B}(Y_k,\rho(Y_k,Y_l))}.

we can define sample version ball divergence as:
\deqn{D_{n,m}=A_{n,m}+C_{n,m}}

BD can be generalized to the \emph{K}-sample problem, i.e. if we 
have \eqn{K} group samples, each group include \eqn{n^{(k)}, k=1,...,K} samples, 
then we can define sample version of generalized ball divergence for \emph{K}-sample problem:
\deqn{\sum_{1 \leq k < l \leq K}{D_{n^{(k)},n^{(l)}}}}

See \code{\link{bd.test}} for a test of multivariate independence based on the 
ball divergence.
}
\examples{
############# Ball Divergence #############
x <- rnorm(50)
y <- rnorm(50)
bd(x, y)
}
\references{
Wenliang Pan, Yuan Tian, Xueqin Wang, Heping Zhang. (2017) Ball divergence: nonparametric two sample test, \emph{The Annals of Statistics}, to appear
}
\seealso{
\code{\link{bd.test}}
}
\author{
Wenliang Pan, Yuan Tian, Xueqin Wang, Heping Zhang
}
