% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/58_fcast_plot.R, R/deprecated.R
\name{plot.bvar_fcast}
\alias{plot.bvar_fcast}
\alias{bv_plot_fcast}
\title{Plotting method for Bayesian VAR forecasts}
\usage{
\method{plot}{bvar_fcast}(x, conf_bands, vars = NULL, variables = NULL,
  orientation = c("vertical", "horizontal"), mar = c(2, 2, 2, 0.5),
  ...)

bv_plot_fcast(x, conf_bands = 0.16, variables = NULL, vars = NULL,
  orientation = c("vertical", "horizontal"), mar = c(2, 2, 2, 0.5),
  ...)
}
\arguments{
\item{x}{A \code{bvar} / \code{bvar_fcast} object, obtained from
\code{\link{bvar}} / \code{\link{predict.bvar}}.}

\item{conf_bands}{Deprecated. Use \code{\link{predict.bvar}}. Numeric vector
of desired confidence bands.}

\item{vars}{Optional numeric or character vector. Used to subset the plot to
certain variables by position or name (must be available). Defaults to
\code{NULL}, i.e. all variables.}

\item{variables}{Optional character vector. Names of all variables in the
object. Used to subset and title. Taken from \code{x$variables} if available.}

\item{orientation}{String indicating the orientation of the plots. Defaults
to \code{"v"} (i.e. vertical); may be set to \code{"h"} (i.e. horizontal).}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns \emph{x} invisibly.
}
\description{
Plotting method for forecasts obtained from \code{\link{bvar}} or
\code{\link{predict.bvar}}. Forecasts of all or a subset of the available
variables can be plotted.
}
\examples{
\donttest{
data <- matrix(rnorm(400), ncol = 4)
x <- bvar(data, lags = 2, fcast = bv_fcast())

# Plot forecasts for all available variables
plot(predict(x))
# Alternatively
plot(x$fcast)

# Subset to variables in positions 1, 2 and 4 via position and name
plot(x$fcast, vars = c(1, 2, 4))
plot(x$fcast,
  variables = c("gdp", "flux", "cpi", "capacitor"),
  vars = c("gdp", "flux", "capacitor")
)

# Use the method to plot and adjust orientation
plot(x$fcast, orientation = "h")

# Adjust confidence bands via predict
plot(predict(x, conf_bands = c(0.01, 0.05)))
}
}
\seealso{
\code{\link{bvar}}; \code{\link{predict.bvar_fcast}}
}
\keyword{BVAR}
\keyword{VAR}
\keyword{forecasts}
\keyword{plot}
\keyword{prediction}
