% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Inspect}
\alias{Inspect}
\title{Percent of vehicles passing inspection by type inspection station}
\format{A data frame/tibble with 174 observations on two variables
\describe{ 
\item{station}{a factor with levels \code{auto inspection},
\code{auto repair}, \code{car care center}, \code{gas station}, \code{new car
dealer}, and \code{tire store}} 
\item{passed}{a factor with levels \code{less than 70\%}, \code{between 70\% and 84\%}, and \code{more than 85\%}}
}}
\source{
\emph{The Charlotte Observer}, December 13, 1992.
}
\usage{
Inspect
}
\description{
Data for Exercise 8.59
}
\examples{

T1 <- xtabs(~ station + passed, data = Inspect)
T1
barplot(T1, beside = TRUE, legend = TRUE)
chisq.test(T1)
rm(T1)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Inspect, aes(x = passed, fill = station)) + 
           geom_bar(position = "dodge") + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
