% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Airdisasters}
\alias{Airdisasters}
\title{Aircraft disasters in five different decades}
\format{A data frame /tibble with 141 observations on the following seven variables
\describe{ 
\item{year}{a numeric vector indicating the year of an aircraft accident} 
\item{deaths}{a numeric vector indicating the number of deaths of an aircraft accident}
\item{decade}{a character vector indicating the decade of an aircraft accident} 
}}
\source{
2000 \emph{World Almanac and Book of Facts}.
}
\usage{
Airdisasters
}
\description{
Data used in Exercise 1.12
}
\examples{

par(las = 1)
stripchart(deaths ~ decade, data = Airdisasters, 
           subset = decade != "1930s" & decade != "1940s", 
           method = "stack", pch = 19, cex = 0.5, col = "red", 
           main = "Aircraft Disasters 1950 - 1990", 
           xlab = "Number of fatalities")
par(las = 0)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
