% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcondYZXAcens2.R
\name{fcondYZXAcens2}
\alias{fcondYZXAcens2}
\title{Conditional posterior distribution of the bivariate latents (Y,Z) in the
case of censoring}
\usage{
fcondYZXAcens2(xleft, xright, censor_code_filters, distr, Tauy, Tauz, J)
}
\description{
This function simulates form the conditional posterior distribution of the
latents (Y,Z).
}
\details{
For internal use
}
\examples{

## The function is currently defined as
function(xleft, xright, censor_code_filters, distr, Tauy, Tauz,
         J) {
  K <- matrix(NA, nrow = length(Tauy), ncol = length(xleft))
  for (i in seq(Tauy)) {
    K[i, ] <- dkcens2(xleft, xright,
      c_code_filters = censor_code_filters,
      distr = distr, mu = Tauy[i], sigma = Tauz[i]
    ) * J[i]
  }
  if (any(is.na(K))) {
    print(K, Tauy, Tauz, J)
  }
  pK <- prop.table(K, margin = 2)
  j <- apply(pK, 2, function(x) {
    sample(length(Tauy),
      size = 1,
      prob = x
    )
  })
  return(matrix(c(y = Tauy[j], z = Tauz[j]),
    nrow = length(xleft),
    ncol = 2
  ))
}
}
\keyword{internal}
