% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeIdDescription.R
\name{getBeIdDescription}
\alias{getBeIdDescription}
\title{Get description of Biological Entity identifiers}
\usage{
getBeIdDescription(ids, be, source, organism, ...)
}
\arguments{
\item{ids}{list of identifiers}

\item{be}{one BE. \strong{Guessed if not provided}}

\item{source}{the BE ID database. \strong{Guessed if not provided}}

\item{organism}{organism name. \strong{Guessed if not provided}}

\item{...}{further arguments
for \link{getBeIdNames} and \link{getBeIdSymbols} functions}
}
\value{
a data.frame providing for each BE IDs
(row.names are provided BE IDs):
\itemize{
\item \strong{id}: the BE ID
\item \strong{symbol}: the BE symbol
\item \strong{name}: the corresponding name
}
}
\description{
This description can be used for annotating tables or graph based on BE IDs.
}
\examples{
\dontrun{
getBeIdDescription(
   ids=c("10", "100"),
   be="Gene",
   source="EntrezGene",
   organism="human"
)
}

}
\seealso{
\link{getBeIdNames}, \link{getBeIdSymbols}
}
