% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{loo.angmcmc}
\alias{loo.angmcmc}
\title{Leave-one-out cross-validation (LOO) for angmcmc objects}
\usage{
\method{loo}{angmcmc}(x, ...)
}
\arguments{
\item{x}{angmcmc object.}

\item{...}{additional model specific arguments to be passed to \link{waic} from loo. For example, \code{int.displ}
specifies integer displacement in wnorm and wnorm2 models. See \link{fit_wnormmix} and
\link{fit_wnorm2mix} for more details.}
}
\description{
Leave-one-out cross-validation (LOO) for angmcmc objects
}
\details{
Note that loo.angmcmc calls \link{loo} for computation. If the likelihood contribution of each data
point for each MCMC iteration is available in \code{object} (can be returned by setting \code{return_llik_contri = TRUE})
during \link{fit_angmix} call), \code{loo.array} is used; otherwise \code{loo.function} is
called. Computation is much faster if the likelihood contributions are available - however, they are very
memory intensive, and by default not returned in \link{fit_angmix}.
}
\examples{
\donttest{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1, return_llik_contri = TRUE)
library(loo)
loo(fit.vmsin.20)
}
}
