% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_vmsin_fns.R
\name{rvmsinmix}
\alias{rvmsinmix}
\alias{dvmsinmix}
\title{The bivariate von Mises sine model mixtures}
\usage{
rvmsinmix(n, kappa1, kappa2, kappa3, mu1, mu2, pmix, method = "naive")

dvmsinmix(x, kappa1, kappa2, kappa3, mu1, mu2, pmix, log = FALSE)
}
\arguments{
\item{n}{number of observations.}

\item{kappa1, kappa2, kappa3}{vectors of concentration parameters; \code{kappa1, kappa2 > 0} for each component.}

\item{mu1, mu2}{vectors of mean parameters.}

\item{pmix}{vector of mixture proportions.}

\item{method}{Rejection sampling method to be used. Available choices are \code{"naive"} (default) or \code{"vmprop"}. See details.}

\item{x}{matrix of angles (in radians) where the density is to be evaluated, with each row being a
single bivariate vector of angles.}

\item{log}{logical. Should the log density be returned instead?}
}
\value{
\code{dvmsinmix} computes the density (vector if x is a two column matrix with more than one row)
and \code{rvmsinmix} generates random deviates from the mixture density.
}
\description{
The bivariate von Mises sine model mixtures
}
\details{
All the argument vectors \code{pmix, kappa1, kappa2, kappa3, mu1} and \code{mu2} must be of
the same length ( = component size of the mixture model), with \eqn{j}-th element corresponding to the
\eqn{j}-th component of the mixture distribution.

The bivariate von Mises sine model mixture distribution with component size \code{K = \link{length}(p.mix)} has density
\deqn{g(x) = \sum p[j] * f(x; \kappa_1[j], \kappa_2[j], \kappa_3[j], \mu_1[j], \mu_2[j])}
where the sum extends over \eqn{j}; \eqn{p[j]; \kappa_1[j], \kappa_2[j], \kappa_3[j]}; and \eqn{\mu_1[j], \mu_2[j]} respectively denote the mixing proportion,
the three concentration parameters and the two mean parameter for the \eqn{j}-th component, \eqn{j = 1, ..., K},
and \eqn{f(. ; \kappa_1, \kappa_2, \kappa_3, \mu_1, \mu_2)} denotes the density function of the von Mises sine model
with concentration parameters \eqn{\kappa_1, \kappa_2, \kappa_3} and  mean parameters \eqn{\mu_1, \mu_2}.
}
\examples{
kappa1 <- c(1, 2, 3)
kappa2 <- c(1, 6, 5)
kappa3 <- c(0, 1, 2)
mu1 <- c(1, 2, 5)
mu2 <- c(0, 1, 3)
pmix <- c(0.3, 0.4, 0.3)
x <- diag(2, 2)
n <- 10

# mixture densities calculated at the rows of x
dvmsinmix(x, kappa1, kappa2, kappa3, mu1, mu2, pmix)

# number of observations generated from the mixture distribution is n
rvmsinmix(n, kappa1, kappa2, kappa3, mu1, mu2, pmix)

}
