% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{add_op_join}
\alias{add_op_join}
\title{Append a join operation to the tbl_kusto object's ops list}
\usage{
add_op_join(
  type,
  x,
  y,
  by = NULL,
  suffix = NULL,
  .strategy = NULL,
  .shufflekeys = NULL,
  .num_partitions = NULL,
  .remote = NULL
)
}
\arguments{
\item{type}{The name of the join type,
one of: inner_join, left_join, right_join, full_join, semi_join, anti_join}

\item{x}{The "left" tbl}

\item{y}{The "right" tbl}

\item{by}{A vector of column names; keys by which tbl x and tbl y will be joined}

\item{suffix}{A vector of strings that will be appended to the names of non-join key columns that exist in both tbl x and tbl y to distinguish them by source tbl.}

\item{.strategy}{A strategy hint to provide to Kusto.}

\item{.shufflekeys}{A character vector of column names to shuffle on, if \code{.strategy = "shuffle"}.}

\item{.num_partitions}{The number of partitions for a shuffle query.}

\item{.remote}{A strategy hint to provide to Kusto for cross-cluster joins.}
}
\description{
Append a join operation to the tbl_kusto object's ops list
}
