\name{AnthropMMD-package}
\alias{AnthropMMD-package}
\alias{AnthropMMD}
\docType{package}
\title{
  An R package for Smith's Mean Measure of Divergence (MMD)
}
\description{
  Offers a graphical user interface for the calculation of the mean
  measure of divergence, with facilities for trait selection and
  graphical representations.
}
\details{
  \tabular{ll}{
    Package: \tab AnthropMMD\cr
    Type: \tab Package\cr
    Version: \tab 3.1.0\cr
    License: \tab CeCILL 2.1\cr
  }
}
\author{
  Frédéric Santos, \email{frederic.santos@u-bordeaux.fr}
}
\references{
  Harris, E. F. and Sjøvold, T. (2004) Calculation of Smith's mean
  measure of divergence for intergroup comparisons using nonmetric
  data. \emph{Dental Anthropology}, \bold{17}(3), 83--93.

  Irish, J. (2010) The mean measure of divergence: Its utility in
  model-free and model-bound analyses relative to the Mahalanobis D2
  distance for nonmetric traits. \emph{American Journal of Human
  Biology}, \bold{22}, 378--395. doi: 10.1002/ajhb.21010

  Nikita, E. (2015) A critical review of the mean measure of divergence
  and Mahalanobis distances using artificial data and new approaches to
  the estimation of biodistances employing nonmetric
  traits. \emph{American Journal of Physical Anthropology}, \bold{157},
  284--294. doi: 10.1002/ajpa.22708

  Santos, F. (2018) AnthropMMD: an R package with a graphical user
  interface for the mean measure of divergence. \emph{American Journal
  of Physical Anthropology}, \bold{165}(1), 200--205. doi:
  10.1002/ajpa.23336
}
\concept{MMD}
\concept{mean measure of divergence}
\concept{nonmetric traits}
\examples{
\dontrun{ start_mmd() }
}
