#' Dataset: Osmocote in \emph{Phalaenopsis} sp.
#'
#' The objective of the work was to evaluate the
#' effect of doses of osmocote (15-09-12-N-P2O5-K2O,
#' respectively) on the initial development of the
#' orchid \emph{Phalaenopsis} sp. The osmocote fertilizer
#' was added in the following doses: 0, 2, 4, 6 and
#' 8 g vase-1. After twelve months, leaf length was
#' evaluated.
#'
#' @docType data
#'
#' @usage data(phao)
#'
#' @format data.frame containing data set
#'   \describe{
#'   \item{\code{dose}}{Numeric vector with doses}
#'   \item{\code{comp}}{Numeric vector with leaf length}
#'   }
#' @seealso \link{pomegranate}, \link{passiflora}, \link{cloro}, \link{enxofre}, \link{laranja}, \link{mirtilo}, \link{porco}, \link{sensorial}, \link{simulate1}, \link{simulate2}, \link{simulate3}, \link{tomate}, \link{weather}
#' @references de Paula, J. C. B., Junior, W. A. R., Shimizu, G. D., Men, G. B., & de Faria, R. T. (2020). Fertilizante de liberacao controlada no crescimento inicial da orquidea \emph{Phalaenopsis} sp. Revista Cultura Agronomica, 29(2), 289-299.
#' @keywords datasets
#'
#' @examples
#' data(phao)
"phao"
