% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_info.R
\name{image_info}
\alias{image_info}
\title{Fetch information about an image, given its image ID}
\usage{
image_info(id, verbose = ala_config()$verbose)
}
\arguments{
\item{id}{character: IDs of images (e.g. as returned by 
\code{\link{occurrences}}  in the imageUrl column). Each ID will be of a 
format something like "84654e14-dc35-4486-9e7c-40eb2f8d3faa"}

\item{verbose}{logical: show additional progress information? 
[default is set by ala_config()]}
}
\value{
A data.frame with one row per \code{id}, and at least the columns 
imageIdentifier and imageURL
}
\description{
Fetch information about an image, given its image ID
}
\examples{
\dontrun{
image_info(c("84654e14-dc35-4486-9e7c-40eb2f8d3faa",
  "39836d30-0761-473d-bac2-9ed9494fd37e",
  "this-is-an-invalid-image-id"))
}
}
\seealso{
\code{\link{ala_config}}, \code{\link{occurrences}}
}
